---
name: alibaba-cloud-model-setup
description: Configure OpenClaw to use Alibaba Cloud Bailian provider (Pay-As-You-Go or Coding Plan) through a strict interactive flow. Supports 5 site options and flagship model series. Use this skill when a user asks to add, switch, or repair Alibaba Cloud/Qwen provider configuration in OpenClaw.
---

# Alibaba Cloud Model Setup (Bailian)

## Overview

Use this skill to configure Alibaba Cloud Bailian as an OpenClaw model provider with minimal manual editing. Supports both **Pay-As-You-Go** (按量付费) and **Coding Plan** (订阅制) subscription types.

## Key Features

### 1️⃣ Fixed Provider Name
- **Provider**: `bailian` (not "balian" - typo fixed!)

### 2️⃣ 5 Site Options

| Plan Type | Site | Base URL |
|-----------|------|----------|
| **Pay-As-You-Go** | China (CN) | `https://dashscope.aliyuncs.com/compatible-mode/v1` |
| **Pay-As-You-Go** | International (INTL) | `https://dashscope-intl.aliyuncs.com/compatible-mode/v1` |
| **Pay-As-You-Go** | US (US) | `https://dashscope-us.aliyuncs.com/compatible-mode/v1` |
| **Coding Plan** | China (CN) | `https://coding.dashscope.aliyuncs.com/v1` |
| **Coding Plan** | International (INTL) | `https://coding-intl.dashscope.aliyuncs.com/v1` |

### 3️⃣ Flagship Model Series (4 series, 2-3 generations each)

**Qwen-Max** (Best Performance):
- `qwen-max`
- `qwen-max-2025-01-25`

**Qwen-Plus** (Balanced):
- `qwen-plus`
- `qwen-plus-2025-01-15`

**Qwen-Flash** (Fast & Cost-Effective):
- `qwen-flash`
- `qwen-flash-2025-01-15`

**Qwen-Coder** (Code Specialist):
- `qwen3-coder-plus`
- `qwen3-coder-next`
- `qwen2.5-coder-32b-instruct`

### 4️⃣ Latest Qwen Models (Available for All Users)

- `qwen3.5-plus`
- `qwen3-max-2026-01-23`

### 5️⃣ Coding Plan Exclusive Models (Third-Party)

- `MiniMax-M2.5` (MiniMax)
- `glm-5` / `glm-4.7` (智谱 AI)
- `kimi-k2.5` (月之暗面)

**Total**: 
- **Pay-As-You-Go**: 11 models (4 flagship series + 2 latest Qwen)
- **Coding Plan**: 15 models (Pay-As-You-Go + 4 third-party exclusive)

## Workflow

1. **Confirm plan type**: Pay-As-You-Go or Coding Plan
2. **Select site**: Based on plan type (3 options for Pay-As-You-Go, 2 for Coding Plan)
3. **Run interactive script** to collect:
   - API key (with validation)
   - API key storage mode (env-var recommended or inline)
   - Primary model selection
   - Whether to set as default model
4. **Validate API key** against selected site before config write
5. **Backup existing config** before modification
6. **Update config** with provider, models, and defaults
7. **Validate JSON** and report final status

## Run Script

Execute:

```bash
python3 scripts/alibaba_cloud_model_setup.py
```

Optional flags for non-interactive use:

```bash
python3 scripts/alibaba_cloud_model_setup.py \
  --plan-type coding \
  --site cn \
  --api-key-source env \
  --env-var DASHSCOPE_API_KEY \
  --models qwen3.5-plus,qwen3-max-2026-01-23,qwen3-coder-plus \
  --model qwen3.5-plus \
  --set-default
```

List available models (no config write):

```bash
python3 scripts/alibaba_cloud_model_setup.py \
  --plan-type coding \
  --site cn \
  --list-models \
  --non-interactive
```

## Safety Rules (Mandatory)

1. Always run `python3 scripts/alibaba_cloud_model_setup.py` for configuration changes.
2. Never edit `~/.openclaw/openclaw.json` manually when this skill is used.
3. Always validate API key before writing config.
4. Always create backup before overwriting existing config.
5. In environment-variable mode, never proceed to config write unless env detection succeeds.

## Default Behavior

- Detect config path in this order:
  - `~/.openclaw/openclaw.json`
  - `~/.moltbot/moltbot.json`
  - `~/.clawdbot/clawdbot.json`
- If none exists, create `~/.openclaw/openclaw.json`
- Write provider `bailian` with OpenAI-compatible API mode
- Create a timestamped backup before overwriting an existing file
- Preserve unrelated config sections
- Set `models.mode` to `merge` to preserve other providers

## Validation Checklist

After configuration:

1. Confirm JSON is valid by running `python3 -m json.tool <config-path>`.
2. Ensure `models.providers.bailian.baseUrl` matches site selection.
3. Ensure `models.providers.bailian.models` contains expected model IDs.
4. Ensure `agents.defaults.model.primary` is `bailian/<model-id>` when default is enabled.
5. Start dashboard (`openclaw dashboard`) or TUI (`openclaw tui`) and verify model call succeeds.

## Example Config Output

### Coding Plan China Site

```json
{
  "models": {
    "mode": "merge",
    "providers": {
      "bailian": {
        "baseUrl": "https://coding.dashscope.aliyuncs.com/v1",
        "apiKey": "YOUR_API_KEY",
        "api": "openai-completions",
        "models": [
          {
            "id": "qwen3.5-plus",
            "name": "Qwen3.5 Plus",
            "reasoning": false,
            "input": ["text", "image"],
            "cost": { "input": 0, "output": 0, "cacheRead": 0, "cacheWrite": 0 },
            "contextWindow": 1000000,
            "maxTokens": 65536
          },
          {
            "id": "qwen3-max-2026-01-23",
            "name": "Qwen3 Max 2026-01-23",
            "reasoning": false,
            "input": ["text"],
            "cost": { "input": 0, "output": 0, "cacheRead": 0, "cacheWrite": 0 },
            "contextWindow": 262144,
            "maxTokens": 65536
          },
          {
            "id": "qwen3-coder-next",
            "name": "Qwen3 Coder Next",
            "reasoning": false,
            "input": ["text"],
            "cost": { "input": 0, "output": 0, "cacheRead": 0, "cacheWrite": 0 },
            "contextWindow": 262144,
            "maxTokens": 65536
          },
          {
            "id": "qwen3-coder-plus",
            "name": "Qwen3 Coder Plus",
            "reasoning": false,
            "input": ["text"],
            "cost": { "input": 0, "output": 0, "cacheRead": 0, "cacheWrite": 0 },
            "contextWindow": 1000000,
            "maxTokens": 65536
          },
          {
            "id": "MiniMax-M2.5",
            "name": "MiniMax M2.5",
            "reasoning": false,
            "input": ["text"],
            "cost": { "input": 0, "output": 0, "cacheRead": 0, "cacheWrite": 0 },
            "contextWindow": 204800,
            "maxTokens": 131072
          },
          {
            "id": "glm-5",
            "name": "GLM-5",
            "reasoning": false,
            "input": ["text"],
            "cost": { "input": 0, "output": 0, "cacheRead": 0, "cacheWrite": 0 },
            "contextWindow": 202752,
            "maxTokens": 16384
          },
          {
            "id": "glm-4.7",
            "name": "GLM-4.7",
            "reasoning": false,
            "input": ["text"],
            "cost": { "input": 0, "output": 0, "cacheRead": 0, "cacheWrite": 0 },
            "contextWindow": 202752,
            "maxTokens": 16384
          },
          {
            "id": "kimi-k2.5",
            "name": "Kimi K2.5",
            "reasoning": false,
            "input": ["text", "image"],
            "cost": { "input": 0, "output": 0, "cacheRead": 0, "cacheWrite": 0 },
            "contextWindow": 262144,
            "maxTokens": 32768
          }
        ]
      }
    }
  },
  "agents": {
    "defaults": {
      "model": {
        "primary": "bailian/qwen3.5-plus"
      },
      "models": {
        "bailian/qwen3.5-plus": {},
        "bailian/qwen3-max-2026-01-23": {},
        "bailian/qwen3-coder-next": {},
        "bailian/qwen3-coder-plus": {},
        "bailian/MiniMax-M2.5": {},
        "bailian/glm-5": {},
        "bailian/glm-4.7": {},
        "bailian/kimi-k2.5": {}
      }
    }
  }
}
```

## References

- Endpoint and field conventions: `references/openclaw_alibaba_cloud.md`

---

*Version: 0.1.4*  
*Updated: 2026-03-02*  
*Changes: Fixed provider name typo (balian → bailian), added Coding Plan support, 5 site options, 11 models for Pay-As-You-Go (flagship + latest Qwen), 15 models for Coding Plan (+4 third-party exclusive)*
