# Alexa Voice Commands

## Essential Commands

### Timers & Alarms
| Command | Action |
|---------|--------|
| "Set a timer for 10 minutes" | Timer |
| "Set a pizza timer for 15 minutes" | Named timer |
| "How much time is left on my timer?" | Check timer |
| "Cancel all timers" | Clear timers |
| "Set an alarm for 7 AM" | Alarm |
| "Set a repeating alarm for weekdays at 6:30 AM" | Recurring alarm |
| "Snooze" | Snooze 9 minutes |
| "Snooze for 15 minutes" | Custom snooze |

### Reminders
| Command | Action |
|---------|--------|
| "Remind me to call mom at 5 PM" | Time-based reminder |
| "Remind me to buy milk when I get home" | Location reminder |
| "Remind me every Monday to check calendar" | Recurring reminder |
| "What are my reminders?" | List all |
| "Delete my reminder to call mom" | Remove specific |

### Lists
| Command | Action |
|---------|--------|
| "Add milk to my shopping list" | Add item |
| "What's on my shopping list?" | Read list |
| "Create a list called vacation packing" | New list |
| "Add sunscreen to vacation packing list" | Add to custom list |

---

## Smart Home

### Lights
| Command | Action |
|---------|--------|
| "Turn on the kitchen lights" | On |
| "Turn off all the lights" | Off all |
| "Dim the bedroom to 30%" | Dim level |
| "Set the living room lights to warm white" | Color temperature |
| "Turn the lights blue" | Color (if supported) |
| "Turn on movie mode" | Scene |

### Thermostat
| Command | Action |
|---------|--------|
| "Set the temperature to 72" | Set target |
| "Make it warmer / cooler" | Adjust relative |
| "What's the temperature inside?" | Read current |
| "Set the thermostat to cool / heat / auto" | Mode change |
| "Turn off the AC" | Disable |

### Locks & Security
| Command | Action |
|---------|--------|
| "Lock the front door" | Lock |
| "Is the front door locked?" | Status |
| "Arm Guard in away mode" | Enable Alexa Guard |
| "Show me the front door camera" | Display (Echo Show) |

### Other Devices
| Command | Action |
|---------|--------|
| "Turn on the TV" | Power (if connected) |
| "Turn on the coffee maker" | Smart plug |
| "Start the robot vacuum" | Vacuum |
| "Open the garage door" | Garage controller |

---

## Music & Media

### Playback
| Command | Action |
|---------|--------|
| "Play some jazz" | Genre |
| "Play the Beatles" | Artist |
| "Play my Discover Weekly on Spotify" | Playlist + service |
| "Play the song that goes 'never gonna give you up'" | Lyrics search |
| "Play some relaxing music" | Mood |
| "Next / Previous / Pause / Resume" | Controls |
| "Shuffle / Loop" | Playback modes |
| "Set volume to 5" / "Volume up" | Volume (1-10 scale) |

### Multi-room
| Command | Action |
|---------|--------|
| "Play music everywhere" | All speakers |
| "Play music on the downstairs group" | Speaker group |
| "Move music to the kitchen" | Transfer playback |
| "Turn it up in the living room" | Volume specific room |

### Podcasts & Audio
| Command | Action |
|---------|--------|
| "Play the Daily podcast" | Specific podcast |
| "Play the latest episode of [podcast]" | New episode |
| "Skip ahead 30 seconds" | Skip |
| "Resume my audiobook" | Audible |

---

## Information & Utilities

### Quick Info
| Command | Action |
|---------|--------|
| "What time is it?" | Time |
| "What's the weather?" | Current + forecast |
| "What's the weather in Tokyo?" | Location weather |
| "Will it rain tomorrow?" | Forecast |
| "What's on my calendar?" | Today's events |
| "When's my next meeting?" | Next event |
| "Add dentist appointment Friday at 2 PM" | Create event |

### Knowledge
| Command | Action |
|---------|--------|
| "What's the capital of Norway?" | Facts |
| "How do you say 'thank you' in Japanese?" | Translation |
| "What's 15% of 80?" | Math |
| "Convert 5 miles to kilometers" | Conversion |
| "Define 'ephemeral'" | Definition |
| "How do you spell 'accommodate'?" | Spelling |
| "Who won the World Cup in 2022?" | Sports/history |

### News & Briefing
| Command | Action |
|---------|--------|
| "What's the news?" | Flash briefing |
| "Play my flash briefing" | Full briefing |
| "What's happening in tech?" | Category news |
| "Tell me about [topic]" | Topic update |

---

## Communication

### Calling
| Command | Action |
|---------|--------|
| "Call Mom" | Contact call |
| "Call [phone number]" | Direct dial |
| "Answer" | Pick up call |
| "Hang up" | End call |
| "Video call John" | Echo Show video |

### Messaging
| Command | Action |
|---------|--------|
| "Send a message to [contact]" | Dictate message |
| "Play my messages" | Listen to messages |
| "Announce 'Dinner is ready'" | All Echo devices in home |
| "Drop in on the kitchen" | Start Drop In |

---

## Accessibility

### Voice Accessibility
| Command | Action |
|---------|--------|
| "Speak slower / faster" | Speech rate |
| "Turn on whisper mode" | Alexa whispers when you whisper |
| "Turn on adaptive listening" | More time to respond |
| "Tap to Alexa" | Touch instead of voice (Echo Show) |

### For Vision
| Command | Action |
|---------|--------|
| "Turn on screen magnifier" | Echo Show zoom |
| "Show my calendar in large print" | Larger display |
| "Turn on VoiceView" | Screen reader for Echo Show |

### Routines for Care
| Example Routine | Use |
|-----------------|-----|
| Medication reminders | Daily reminder at specific times |
| "Help" command | Send notification to caregiver |
| Motion-triggered | Check-in if no motion detected |

---

## Fun & Entertainment

| Command | Action |
|---------|--------|
| "Tell me a joke" | Random joke |
| "Play 20 questions" | Game |
| "Roll a dice" / "Flip a coin" | Random |
| "Sing happy birthday" | Song |
| "Tell me something interesting" | Random fact |
| "What's your favorite color?" | Easter eggs |
| "Meow" | Various responses |
| "Open [skill name]" | Launch third-party skill |
