---
name: akshare-stock
description: A股量化数据分析工具，基于AkShare库获取A股行情、财务数据、板块信息等。用于回答关于A股股票查询、行情数据、财务分析、选股等问题。
---

# A股量化 - AkShare 数据接口

## 快速开始

安装依赖：
```bash
pip install akshare
```

## 支持的功能

### 1. 实时行情查询

```python
import akshare as ak

# 个股实时行情
stock_zh_a_spot_em()
stock_zh_a_spot_em(symbol="北证A股")
```

### 2. 历史K线数据

```python
import akshare as ak

# 日K线
stock_zh_a_hist(symbol="000001", period="daily", start_date="20240101", end_date="20241231", adjust="qfq")

# 周K线
stock_zh_a_hist(symbol="000001", period="weekly", start_date="20240101", end_date="20241231", adjust="qfq")

# 月K线
stock_zh_a_hist(symbol="000001", period="monthly", start_date="20240101", end_date="20241231", adjust="qfq")
```

### 3. 财务数据

```python
import akshare as ak

# 财务报表
stock_financial_abstract_ths(symbol="000001", indicator="按报告期")

# 主要财务指标
stock_financial_analysis_indicator(symbol="000001")
```

### 4. 板块/行业分析

```python
import akshare as ak

# 行业板块行情
stock_board_industry_name_em()

# 概念板块行情
stock_board_concept_name_em()

# 板块内个股
stock_board_industry_cons_em(symbol="半导体")
```

### 5. 资金流向

```python
import akshare as ak

# 个股资金流向
stock_individual_fund_flow(stock="000001", market="sh")

# 大单净流入
stock_individual_fund_flow(stock="000001", market="sh", symbol="大单净流入")
```

### 6. 龙虎榜

```python
import akshare as ak

# 每日龙虎榜
stock_lhb_detail_em(date="20240930")

# 机构调研
stock_zlzj_em()
```

### 7. 新股/IPO

```python
import akshare as ak

# 新股申购
stock_new_ipo_em()

# 待上市新股
stock_new_ipo_start_em()
```

### 8. 融资融券

```python
import akshare as ak

# 融资融券
stock_margin_sse(symbol="600000")

# 融资融券明细
stock_rzrq_detail_em(symbol="600000", date="20240930")
```

## 常用股票代码

- **平安银行**: 000001
- **贵州茅台**: 600519
- **宁德时代**: 300750
- **比亚迪**: 002594
- **招商银行**: 600036

## 备选方案: Baostock

如果 AkShare 安装失败，可使用 baostock（更轻量）:

```python
import baostock as bs

# 登录
lg = bs.login()
print(lg.error_msg)

# 获取历史K线
rs = bs.query_history_k_data_plus('sh.600519',
    'date,code,open,high,low,close,volume',
    start_date='20250101',
    end_date='20251231')

data_list = []
while rs.next:
    data_list.append(rs.get_row_data())
    
bs.logout()
```

## 注意事项

1. 数据仅供学术研究，不构成投资建议
2. 接口可能因目标网站变动而失效
3. 建议添加异常处理和重试机制
4. **当前环境网络问题可能导致测试失败，请在本地环境测试**
