---
name: openclaw-media-gen
description: "Generate images & videos with AIsa. Gemini 3 Pro Image (image) + Qwen Wan 2.6 (video) via one API key."
homepage: https://openclaw.ai
metadata: {"openclaw":{"emoji":"🎬","requires":{"bins":["python3","curl"],"env":["AISA_API_KEY"]},"primaryEnv":"AISA_API_KEY"}}
---

# OpenClaw Media Gen 🎬

用 AIsa API 一把钥匙生成**图片**与**视频**：

- **图片**：`gemini-3-pro-image-preview`（Gemini GenerateContent）
- **视频**：`wan2.6-t2v`（通义万相 / Qwen Wan 2.6，异步任务）

API 文档索引见 [AIsa API Reference](https://aisa.mintlify.app/api-reference/introduction)（可从 `https://aisa.mintlify.app/llms.txt` 找到所有页面）。

## 🔥 你可以做什么

### 图片生成（Gemini）
```
"生成一张赛博朋克风格的城市夜景，霓虹灯，雨夜，电影感"
```

### 视频生成（Wan 2.6）
```
"用一张参考图生成 5 秒镜头：镜头缓慢推进，风吹动头发，电影感，浅景深"
```

## Quick Start

```bash
export AISA_API_KEY="your-key"
```

---

## 🖼️ Image Generation (Gemini)

### Endpoint

- Base URL: `https://api.aisa.one/v1`
- `POST /models/{model}:generateContent`

文档：`google-gemini-chat`（GenerateContent）见 `https://aisa.mintlify.app/api-reference/chat/chat-api/google-gemini-chat.md`。

### curl 示例（返回 inline_data 时为图片）

```bash
curl -X POST "https://api.aisa.one/v1/models/gemini-3-pro-image-preview:generateContent" \
  -H "Authorization: Bearer $AISA_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "contents":[
      {"role":"user","parts":[{"text":"A cute red panda, ultra-detailed, cinematic lighting"}]}
    ]
  }'
```

> 说明：该接口的响应中可能出现 `candidates[].parts[].inline_data`（通常包含 base64 数据与 mime 类型）；客户端脚本会自动解析并保存文件。

---

## 🎞️ Video Generation (Qwen Wan 2.6 / Tongyi Wanxiang)

### Create task

- Base URL: `https://api.aisa.one/apis/v1`
- `POST /services/aigc/video-generation/video-synthesis`
- Header：`X-DashScope-Async: enable`（必填，异步）

文档：`video-generation` 见 `https://aisa.mintlify.app/api-reference/aliyun/video/video-generation.md`。

```bash
curl -X POST "https://api.aisa.one/apis/v1/services/aigc/video-generation/video-synthesis" \
  -H "Authorization: Bearer $AISA_API_KEY" \
  -H "Content-Type: application/json" \
  -H "X-DashScope-Async: enable" \
  -d '{
    "model":"wan2.6-t2v",
    "input":{
      "prompt":"cinematic close-up, slow push-in, shallow depth of field",
      "img_url":"https://upload.wikimedia.org/wikipedia/commons/thumb/3/3a/Cat03.jpg/320px-Cat03.jpg"
    },
    "parameters":{
      "resolution":"720P",
      "duration":5,
      "shot_type":"single",
      "watermark":false
    }
  }'
```

### Poll task

- `GET /services/aigc/tasks?task_id=...`

文档：`task` 见 `https://aisa.mintlify.app/api-reference/aliyun/video/task.md`。

```bash
curl "https://api.aisa.one/apis/v1/services/aigc/tasks?task_id=YOUR_TASK_ID" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

---

## Python Client

```bash
# 生成图片（保存到本地文件）
python3 {baseDir}/scripts/media_gen_client.py image \
  --prompt "A cute red panda, cinematic lighting" \
  --out "out.png"

# 创建视频任务（需要 img_url）
python3 {baseDir}/scripts/media_gen_client.py video-create \
  --prompt "cinematic close-up, slow push-in" \
  --img-url "https://upload.wikimedia.org/wikipedia/commons/thumb/3/3a/Cat03.jpg/320px-Cat03.jpg" \
  --duration 5

# 轮询任务状态
python3 {baseDir}/scripts/media_gen_client.py video-status --task-id YOUR_TASK_ID

# 等待直到成功（可选：成功后打印 video_url）
python3 {baseDir}/scripts/media_gen_client.py video-wait --task-id YOUR_TASK_ID --poll 10 --timeout 600

# 等待直到成功并自动下载 mp4
python3 {baseDir}/scripts/media_gen_client.py video-wait --task-id YOUR_TASK_ID --download --out out.mp4
```

