---
name: AIsaFinancialData
description: "Query real-time and historical financial data across equities and crypto—prices, market moves, metrics, and trends for analysis, alerts, and reporting."
homepage: https://openclaw.ai
metadata: {"openclaw":{"emoji":"📊","requires":{"bins":["curl","python3"],"env":["AISA_API_KEY"]},"primaryEnv":"AISA_API_KEY"}}
---

# OpenClaw Market 📊

**Complete market data for autonomous agents. Powered by AIsa.**

One API key. Stocks + Crypto + Financials. Everything you need.

## 🔥 What Can You Do?

### Cross-Asset Portfolio
```
"Get BTC, ETH prices alongside AAPL, NVDA stock data for my portfolio"
```

### Investment Research
```
"Full analysis: NVDA price trends, insider trades, analyst estimates, SEC filings"
```

### Crypto Tracking
```
"Real-time prices for BTC, ETH, SOL with 30-day historical charts"
```

### Earnings Analysis
```
"Get Tesla earnings reports, analyst estimates, and price reaction"
```

### Market Screening
```
"Find stocks with P/E < 15 and revenue growth > 20%"
```

### Whale Watching
```
"Track insider trades at Apple and correlate with price movements"
```

## Quick Start

```bash
export AISA_API_KEY="your-key"
```

---

## 🏦 Traditional Finance

### Stock Prices

```bash
# Historical price data (daily)
curl "https://api.aisa.one/apis/v1/financial/prices?ticker=AAPL&interval=day&interval_multiplier=1&start_date=2025-01-01&end_date=2025-12-31" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Weekly price data
curl "https://api.aisa.one/apis/v1/financial/prices?ticker=AAPL&interval=week&interval_multiplier=1&start_date=2025-01-01&end_date=2025-12-31" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Minute-level data (intraday)
curl "https://api.aisa.one/apis/v1/financial/prices?ticker=AAPL&interval=minute&interval_multiplier=5&start_date=2025-01-15&end_date=2025-01-15" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

**Parameters:**
- `ticker`: Stock symbol (required)
- `interval`: `second`, `minute`, `day`, `week`, `month`, `year` (required)
- `interval_multiplier`: Multiplier for interval, e.g., 5 for 5-minute bars (required)
- `start_date`: Start date YYYY-MM-DD (required)
- `end_date`: End date YYYY-MM-DD (required)

### Company News

```bash
# Get news by ticker
curl "https://api.aisa.one/apis/v1/financial/news?ticker=AAPL&limit=10" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

### Financial Statements

```bash
# All financial statements
curl "https://api.aisa.one/apis/v1/financial/financial_statements/all?ticker=AAPL" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Income statements
curl "https://api.aisa.one/apis/v1/financial/financial_statements/income?ticker=AAPL" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Balance sheets
curl "https://api.aisa.one/apis/v1/financial/financial_statements/balance?ticker=AAPL" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Cash flow statements
curl "https://api.aisa.one/apis/v1/financial/financial_statements/cash?ticker=AAPL" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

### Financial Metrics

```bash
# Real-time financial metrics snapshot
curl "https://api.aisa.one/apis/v1/financial/financial-metrics/snapshot?ticker=AAPL" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Historical financial metrics
curl "https://api.aisa.one/apis/v1/financial/financial-metrics?ticker=AAPL" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

### Analyst Estimates

```bash
# Earnings per share estimates
curl "https://api.aisa.one/apis/v1/financial/analyst/eps?ticker=AAPL&period=annual" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

### Insider Trading

```bash
# Get insider trades
curl "https://api.aisa.one/apis/v1/financial/insider/trades?ticker=AAPL" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

### Institutional Ownership

```bash
# Get institutional ownership
curl "https://api.aisa.one/apis/v1/financial/institutional/ownership?ticker=AAPL" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

### SEC Filings

```bash
# Get SEC filings
curl "https://api.aisa.one/apis/v1/financial/sec/filings?ticker=AAPL" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Get SEC filing items
curl "https://api.aisa.one/apis/v1/financial/sec/items?ticker=AAPL" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

### Company Facts

```bash
# Get company facts by CIK
curl "https://api.aisa.one/apis/v1/financial/company/facts?ticker=AAPL" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

### Stock Screener

```bash
# Screen for stocks matching criteria
curl -X POST "https://api.aisa.one/apis/v1/financial/search/stock" \
  -H "Authorization: Bearer $AISA_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"filters":{"pe_ratio":{"max":15},"revenue_growth":{"min":0.2}}}'
```

### Interest Rates

```bash
# Current interest rates
curl "https://api.aisa.one/apis/v1/financial/interest_rates/snapshot" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Historical interest rates
curl "https://api.aisa.one/apis/v1/financial/interest_rates/historical?bank=fed" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

---

## ₿ Cryptocurrency

### Real-Time Price Snapshot

```bash
# Get current BTC price (use ticker format: SYMBOL-USD)
curl "https://api.aisa.one/apis/v1/financial/crypto/prices/snapshot?ticker=BTC-USD" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Get current ETH price
curl "https://api.aisa.one/apis/v1/financial/crypto/prices/snapshot?ticker=ETH-USD" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Get current SOL price
curl "https://api.aisa.one/apis/v1/financial/crypto/prices/snapshot?ticker=SOL-USD" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Get TRUMP token price
curl "https://api.aisa.one/apis/v1/financial/crypto/prices/snapshot?ticker=TRUMP-USD" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

**Note:** Crypto tickers use format `SYMBOL-USD` (e.g., `BTC-USD`, `ETH-USD`).

### Historical Price Data

```bash
# Get BTC historical prices (daily)
curl "https://api.aisa.one/apis/v1/financial/crypto/prices?ticker=BTC-USD&interval=day&interval_multiplier=1&start_date=2025-01-01&end_date=2025-01-31" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Get ETH hourly data
curl "https://api.aisa.one/apis/v1/financial/crypto/prices?ticker=ETH-USD&interval=minute&interval_multiplier=60&start_date=2025-01-15&end_date=2025-01-16" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

### Supported Cryptocurrencies

| Ticker | Name |
|--------|------|
| BTC-USD | Bitcoin |
| ETH-USD | Ethereum |
| SOL-USD | Solana |
| BNB-USD | Binance Coin |
| XRP-USD | Ripple |
| DOGE-USD | Dogecoin |
| ADA-USD | Cardano |
| AVAX-USD | Avalanche |
| DOT-USD | Polkadot |
| MATIC-USD | Polygon |
| LINK-USD | Chainlink |
| UNI-USD | Uniswap |
| ATOM-USD | Cosmos |
| LTC-USD | Litecoin |
| TRUMP-USD | Trump Token |
| ... | And many more |

---

## Python Client

```bash
# ==================== Stock Data ====================
# Note: start_date and end_date are REQUIRED for prices
python3 {baseDir}/scripts/market_client.py stock prices --ticker AAPL --start 2025-01-01 --end 2025-01-31
python3 {baseDir}/scripts/market_client.py stock prices --ticker AAPL --start 2025-01-01 --end 2025-01-31 --interval week
python3 {baseDir}/scripts/market_client.py stock news --ticker AAPL --count 10

# ==================== Financial Statements ====================
python3 {baseDir}/scripts/market_client.py stock statements --ticker AAPL --type all
python3 {baseDir}/scripts/market_client.py stock statements --ticker AAPL --type income
python3 {baseDir}/scripts/market_client.py stock statements --ticker AAPL --type balance
python3 {baseDir}/scripts/market_client.py stock statements --ticker AAPL --type cash

# ==================== Metrics & Analysis ====================
python3 {baseDir}/scripts/market_client.py stock metrics --ticker AAPL
python3 {baseDir}/scripts/market_client.py stock analyst --ticker AAPL

# ==================== Insider & Institutional ====================
python3 {baseDir}/scripts/market_client.py stock insider --ticker AAPL
python3 {baseDir}/scripts/market_client.py stock ownership --ticker AAPL

# ==================== SEC Filings ====================
python3 {baseDir}/scripts/market_client.py stock filings --ticker AAPL

# ==================== Stock Screener ====================
python3 {baseDir}/scripts/market_client.py stock screen --pe-max 15 --growth-min 0.2

# ==================== Interest Rates ====================
python3 {baseDir}/scripts/market_client.py stock rates
python3 {baseDir}/scripts/market_client.py stock rates --historical

# ==================== Crypto Data ====================
# Note: Use ticker format SYMBOL-USD (or just SYMBOL, auto-converted)
python3 {baseDir}/scripts/market_client.py crypto snapshot --ticker BTC-USD
python3 {baseDir}/scripts/market_client.py crypto snapshot --ticker ETH  # Auto-converts to ETH-USD
python3 {baseDir}/scripts/market_client.py crypto historical --ticker BTC-USD --start 2025-01-01 --end 2025-01-31
python3 {baseDir}/scripts/market_client.py crypto portfolio --tickers BTC-USD,ETH-USD,SOL-USD
```

---

## API Endpoints Reference

### Traditional Finance

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/financial/prices` | GET | Historical stock prices (requires interval params) |
| `/financial/news` | GET | Company news by ticker |
| `/financial/financial_statements/all` | GET | All financial statements |
| `/financial/financial_statements/income` | GET | Income statements |
| `/financial/financial_statements/balance` | GET | Balance sheets |
| `/financial/financial_statements/cash` | GET | Cash flow statements |
| `/financial/financial-metrics/snapshot` | GET | Real-time financial metrics |
| `/financial/financial-metrics` | GET | Historical metrics |
| `/financial/analyst/eps` | GET | EPS estimates |
| `/financial/insider/trades` | GET | Insider trades |
| `/financial/institutional/ownership` | GET | Institutional ownership |
| `/financial/sec/filings` | GET | SEC filings |
| `/financial/sec/items` | GET | SEC filing items |
| `/financial/company/facts` | GET | Company facts |
| `/financial/search/stock` | POST | Stock screener |
| `/financial/interest_rates/snapshot` | GET | Current interest rates |
| `/financial/interest_rates/historical` | GET | Historical rates |

### Cryptocurrency

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/financial/crypto/prices/snapshot` | GET | Real-time price snapshot |
| `/financial/crypto/prices` | GET | Historical OHLCV data |

---

## Pricing

| API | Cost |
|-----|------|
| Stock prices | ~$0.001 |
| Company news | ~$0.001 |
| Financial statements | ~$0.002 |
| Analyst estimates | ~$0.002 |
| SEC filings | ~$0.001 |
| Crypto snapshot | ~$0.0005 |
| Crypto historical | ~$0.001 |

Every response includes `usage.cost` and `usage.credits_remaining`.

---

## Get Started

1. Sign up at [aisa.one](https://aisa.one)
2. Get your API key
3. Add credits (pay-as-you-go)
4. Set environment variable: `export AISA_API_KEY="your-key"`

## Full API Reference

See [API Reference](https://aisa.mintlify.app/api-reference/introduction) for complete endpoint documentation.
