# Battery Maintenance - AirTag

Use this reference to prevent avoidable downtime and false battery assumptions.

## Replacement Signals

Treat battery replacement as likely when:
- Find My repeatedly shows low-battery alerts across multiple checks.
- Ring sound is inconsistent or weak despite normal connectivity.
- Battery age is near expected service window and behavior degraded over time.

Do not conclude battery failure from one transient offline event.

## Controlled Replacement Workflow

1. Capture baseline state before change:
   - Last seen time
   - Alert text
   - Ring behavior
2. Replace battery using the exact model spec recommended by Apple.
3. Re-seat cover and test contact consistency with two ring checks.
4. Re-open Find My and verify state after a short stabilization window.
5. Record date and outcome in maintenance notes.

## Post-Replacement Validation

Minimum verification set:
- Ring command works reliably.
- Last-seen updates resume normally.
- No immediate recurring low-battery alert.

If validation fails, inspect contact pressure and battery orientation before re-pairing.

## Preventive Cadence

- Keep one spare battery available for each two active tags.
- Review maintenance notes before travel periods.
- If failures repeat in one tag, escalate to hardware integrity checks rather than endless replacements.
