# Anti-Stalking Safety - AirTag

Use this flow when the user reports an unknown AirTag notification or unexplained tracking concern.

## Immediate Priorities

1. Prioritize personal safety before technical diagnosis.
2. Move to a safer public or trusted location if risk feels active.
3. Avoid direct confrontation with unknown individuals.

## Triage Questions

Ask only what is needed to classify urgency:
- Is the alert active right now?
- Is the user alone or in a vulnerable setting?
- Is there a plausible benign explanation (borrowed bag, shared vehicle, recent contact)?

If urgency is high, keep instructions short and actionable.

## Technical Verification Flow

1. Confirm the alert source and timestamp in Find My notifications.
2. Use available device guidance to locate the unknown tag safely.
3. Separate "unknown nearby" from "moving with you over time" before drawing conclusions.
4. If device support allows, follow system prompts to identify or disable the tag.

## Evidence and Escalation

- Encourage preserving timeline details (places, timestamps, repeated sightings).
- Recommend contacting local authorities or trusted security channels when risk is credible.
- Keep wording factual and avoid legal claims beyond observable events.

## Communication Guardrails

- Do not promise certainty from limited data.
- Do not advise unsafe searches in isolated places.
- Do not dismiss user concern as overreaction.
