---
name: aimine
description: Mine AIT (Proof of AI Work) on BNB Chain. Install, configure, start/stop mining entirely from OpenClaw. No terminal or manual file edits required.
metadata: {"openclaw":{"requires":{"bins":["node","npm","git"]},"primaryEnv":"PRIVATE_KEY"}}
---

# AI Mine (PoAIW) — OpenClaw Skill

This skill lets users **install**, **configure**, and **start/stop** AIT mining entirely from OpenClaw. All actions are performed by the agent via Exec; the user never needs to open a terminal or edit files manually.

**Supported user intents (English trigger phrases):**

- **Install** — e.g. "install AIT mining", "set up AIT miner", "install the miner"
- **Configure** — e.g. "configure AIT mining", "configure mining", "set up my keys"
- **Start mining** — e.g. "start mining", "start AIT mining", "begin mining"
- **Stop mining** — e.g. "stop mining", "stop AIT mining"
- **Mining status** — e.g. "mining status", "status", "how is mining doing"
- **Balance** — e.g. "AIT balance", "check balance", "my AIT balance"

**Conventions:**

- `AIMINE_DIR`: base directory for the repo; default `~/PoAIW`. Miner directory is `$AIMINE_DIR/miner`.
- Port for the miner web API: `3000` (localhost only).
- Keys: user can set `PRIVATE_KEY` and either `OPENAI_KEY` or `OPENAI_API_KEY` in OpenClaw skill config (env injection), or provide them once in chat. The miner accepts both env var names for the OpenAI key. Then the agent runs init with those values.

---

## When the user wants to INSTALL the miner

Run (use AIMINE_DIR if set, else default to $HOME/PoAIW):

```
AIMINE_DIR=${AIMINE_DIR:-$HOME/PoAIW}
[ -d "$AIMINE_DIR/.git" ] || git clone https://github.com/AIMineRes/PoAIW.git "$AIMINE_DIR"
cd "$AIMINE_DIR/miner" && npm install
```

Do not ask the user to open a terminal or run these manually.

---

## When the user wants to CONFIGURE mining

The user must have provided wallet private key and OpenAI API key (either in OpenClaw skill config as PRIVATE_KEY and OPENAI_KEY or OPENAI_API_KEY, or in the conversation). If users get "invalid API key", have them check: no leading/trailing spaces, key starts with sk-, and if using OpenClaw config try setting OPENAI_API_KEY (some UIs use that name).

- **If keys are in environment** (e.g. injected by OpenClaw skill config): run  
  `cd "$AIMINE_DIR/miner" && npx ts-node src/index.ts init --from-env`  
  (ensure AIMINE_DIR is set or use $HOME/PoAIW/miner).

- **If the user provided keys in the message**: run  
  `cd "$AIMINE_DIR/miner" && npx ts-node src/index.ts init --private-key <key> --openai-key <key>`  
  using the keys they provided. Do not echo the keys back in full.

Do not ask the user to manually edit .env or openclaw.json.

---

## When the user wants to START mining

Run the one-shot script so that the web server is started in the background if needed, then the API is called. Do **not** tell the user to "run npm run web first".

```
cd "${AIMINE_DIR:-$HOME/PoAIW}/miner" && node scripts/start-mining.js
```

If AIMINE_DIR is not set, use $HOME/PoAIW (or equivalent on the host). The script will start the web server on port 3000 if it is not already listening, wait a few seconds, then POST to http://127.0.0.1:3000/api/start.

---

## When the user wants to STOP mining

Run:

```
curl -s -X POST http://127.0.0.1:3000/api/stop
```

---

## When the user wants MINING STATUS

Run:

```
curl -s http://127.0.0.1:3000/api/status
```

Then summarize the JSON (miningActive, blocksMined, tokenBalance, bnbBalance, hashRate) in a short reply.

---

## When the user wants AIT BALANCE (wallet / mining stats)

Run:

```
cd "${AIMINE_DIR:-$HOME/PoAIW}/miner" && npx ts-node src/index.ts balance
```

Summarize the output for the user.

---

## Summary

- **Install**: clone repo into AIMINE_DIR (default ~/PoAIW), then `cd miner && npm install`.
- **Configure**: `ai-mine init --from-env` (if keys in env) or `ai-mine init --private-key ... --openai-key ...` (if user gave keys in chat).
- **Start**: `node scripts/start-mining.js` in the miner directory (no need for user to run npm run web).
- **Stop**: `curl -s -X POST http://127.0.0.1:3000/api/stop`.
- **Status**: `curl -s http://127.0.0.1:3000/api/status`.
- **Balance**: `npx ts-node src/index.ts balance` in the miner directory.

Always use the miner directory as `$AIMINE_DIR/miner` with AIMINE_DIR defaulting to ~/PoAIW when not set.
