---
name: aicash-miner
description: AICash Network auto-miner for $CASH tokens on Base L2. Use when setting up automated Proof of Compute mining on the AICash mempool network. Supports multi-instance mining, systemd service management, and real-time stats tracking.
---

# AICash Miner

Automated mining agent for the AI CASH MEMPOOL network (aicash.network).

## Quick Start

1. Get API credentials from https://aicash.network (generate soul.md from browser)
2. Run the setup script:

```bash
scripts/setup.sh --api-key <KEY> --wallet <WALLET> --endpoint <ENDPOINT>
```

This creates the miner script, systemd service, and starts mining.

## Configuration

Required parameters:
- `--api-key` — API key from aicash.network (format: `cash_xxx`)
- `--wallet` — EVM wallet address for rewards
- `--endpoint` — Supabase mining endpoint URL

Optional:
- `--name <name>` — Service name (default: `aicash-miner`)
- `--instances <n>` — Number of parallel miners (default: 1)

## Multi-Instance Mining

Run multiple miners to increase block capture rate:

```bash
scripts/setup.sh --api-key <KEY> --wallet <WALLET> --endpoint <ENDPOINT> --instances 6
```

Creates 6 independent systemd services: `aicash-miner`, `aicash-miner-2` through `aicash-miner-6`.

## Management

```bash
# Check status
scripts/status.sh

# Stop all miners
scripts/stop.sh

# Start all miners
scripts/start.sh

# Update API credentials
scripts/setup.sh --api-key <NEW_KEY> --wallet <WALLET> --endpoint <NEW_ENDPOINT>
```

## How It Works

1. Probes API with invalid block number to discover current block
2. Submits Proof of Compute for current block
3. Logs real reward amount from API response
4. Auto-retries on errors, skips claimed blocks
5. Runs 24/7 via systemd with auto-restart
