---
name: ai-video-script
description: AI视频脚本生成器。根据用户输入的主题/关键词，生成完整的视频脚本，包含分镜描述、画面提示词、配音文案。适用于短视频创作者、AI视频制作者、内容营销人员。触发词：视频脚本、分镜、AI视频、短视频文案、视频策划。
---

# AI 视频脚本生成器

快速生成 AI 视频脚本的工具，包含分镜、提示词、配音文案。

## 快速开始

### 基本用法

```
输入：主题或关键词
输出：完整视频脚本
```

### 脚本结构

每个脚本包含：

1. **视频概述**
   - 标题
   - 时长
   - 风格定位
   - 目标受众

2. **分镜表**
   - 场次
   - 画面描述
   - 镜头运动
   - 时长

3. **画面提示词**
   - AI 绘画/视频提示词
   - 适配主流工具（CogVideoX、Midjourney、SD）

4. **配音文案**
   - 旁白文本
   - 字幕文本
   - 情绪标注

## 脚本模板

### 短视频（15-60秒）

```markdown
# [标题]

## 概述
- 时长：30秒
- 风格：轻松/专业/故事性
- 目标：引起共鸣/传递知识/带货

## 分镜表

### 场次1（0-5秒）
- **画面**：[具体描述]
- **镜头**：特写/中景/远景，推/拉/摇/移
- **提示词**：[AI生成提示词]
- **配音**：[文案]
- **字幕**：[显示文字]

### 场次2（5-15秒）
...

## 完整提示词列表

1. 场次1提示词：...
2. 场次2提示词：...

## 配音脚本

[完整旁白文案]
```

### 长视频（1-5分钟）

结构同上，但分镜更详细，场次更多。

## 生成流程

1. **理解需求**
   - 主题/产品/故事
   - 目标受众
   - 视频风格
   - 时长要求

2. **规划结构**
   - 开头（吸引注意）
   - 中间（核心内容）
   - 结尾（行动号召）

3. **生成分镜**
   - 每个镜头的目的
   - 画面构图
   - 镜头运动

4. **撰写提示词**
   - 考虑 AI 工具特性
   - 包含风格、光影、构图
   - 中英文对照

5. **编写文案**
   - 口语化
   - 节奏感
   - 情绪引导

## 提示词规范

### CogVideoX 格式

```
[主体动作], [场景环境], [镜头运动], [风格], [画质]

示例：
A young woman walking on the beach at sunset, golden hour lighting, 
slow motion, cinematic style, 4K quality
```

### Midjourney 格式

```
[主体], [动作/状态], [场景], [光影], [风格], --ar 16:9

示例：
Young woman, walking peacefully, beach at sunset, golden hour, 
cinematic style --ar 16:9
```

## 示例

### 示例1：产品介绍（30秒）

```markdown
# 智能水杯介绍

## 概述
- 时长：30秒
- 风格：科技感、简洁
- 目标：突出产品特点，引起购买欲

## 分镜表

### 场次1（0-3秒）：开篇
- **画面**：水杯特写，光影流动
- **镜头**：缓慢推进
- **提示词**：Smart water bottle on wooden table, soft natural lighting, 
  product photography, minimalist background --ar 16:9
- **配音**：还在为忘记喝水烦恼吗？
- **字幕**：智能水杯

### 场次2（3-10秒）：功能展示
- **画面**：水杯LED屏幕亮起，显示温度
- **镜头**：侧面特写
- **提示词**：Close-up of water bottle LED display showing temperature, 
  blue glow, high tech aesthetic --ar 16:9
- **配音**：智能温显，24小时保温，让每一口水都是最佳温度。
- **字幕**：智能温显 | 24H保温

### 场次3（10-20秒）：使用场景
- **画面**：办公桌、健身房、户外场景快切
- **镜头**：快速切换
- **提示词**：Multiple scenes: office desk, gym, outdoor hiking, 
  water bottle in each scene, lifestyle photography --ar 16:9
- **配音**：无论办公、健身还是户外，它都是你的贴心伙伴。
- **字幕**：办公 | 健身 | 户外

### 场次4（20-30秒）：结尾
- **画面**：水杯与手机APP联动
- **镜头**：特写 + 拉远
- **提示词**：Water bottle and smartphone showing app interface, 
  connection notification, modern tech style --ar 16:9
- **配音**：智能提醒，健康生活从一杯水开始。点击下方链接了解详情。
- **字幕**：智能提醒 | 健康生活 | [品牌LOGO]
```

### 示例2：知识科普（60秒）

```markdown
# 为什么人会做梦？

## 概述
- 时长：60秒
- 风格：科普、有趣
- 目标：传递知识，引起兴趣

## 分镜表

### 场次1（0-5秒）：引入
- **画面**：夜晚城市，窗户里的灯光熄灭
- **镜头**：航拍俯视
- **提示词**：City skyline at night, lights turning off one by one, 
  peaceful atmosphere, aerial shot --ar 16:9
- **配音**：每晚，我们都会进入一个神奇的世界...
- **字幕**：我们为什么会做梦？

### 场次2（5-20秒）：科学解释
- **画面**：大脑3D模型，神经元活动
- **镜头**：微观视角，快速剪辑
- **提示词**：3D brain model, neurons firing, blue and purple lights, 
  scientific visualization --ar 16:9
- **配音**：当我们睡眠时，大脑并没有休息。在REM快速眼动期，神经元活跃度甚至超过清醒时。
- **字幕**：REM快速眼动期 | 大脑在"加班"

### 场次3（20-40秒）：梦境功能
- **画面**：记忆整理、情绪处理的视觉化表现
- **镜头**：抽象动画
- **提示词**：Abstract visualization of memory consolidation, 
  emotions being processed, colorful particles flowing --ar 16:9
- **配音**：科学家认为，做梦帮助我们整理记忆、处理情绪，甚至解决白天的问题。
- **字幕**：整理记忆 | 处理情绪 | 灵感来源

### 场次4（40-60秒）：结尾
- **画面**：日出，人醒来
- **镜头**：延时摄影
- **提示词**：Sunrise through window, person waking up peacefully, 
  warm golden light, timelapse --ar 16:9
- **配音**：所以下次做梦时，也许是你的大脑在帮你成长。关注我，了解更多有趣知识。
- **字幕**：梦是大脑的成长时间 | 关注我
```

## 高级功能

### 批量生成

一次生成多个脚本变体：

```
输入：主题 + 多个角度/风格
输出：3-5个不同版本的脚本
```

### 风格定制

预设风格：
- **商业**：专业、权威、产品导向
- **故事**：情感、冲突、转折
- **教育**：清晰、逻辑、知识点
- **娱乐**：轻松、有趣、网感

### 时长优化

根据平台调整：
- **抖音/快手**：15-60秒
- **B站/YouTube**：3-10分钟
- **微信视频号**：30秒-3分钟

## 注意事项

1. **版权意识**
   - 提示词原创
   - 避免侵权元素

2. **平台规范**
   - 符合平台内容要求
   - 注意敏感词

3. **实用性**
   - 脚本可执行
   - 提示词可用
   - 文案自然

---

_让视频创作更高效_
