# 🎬 AI UGC Video Ad Factory — Generate Authentic User-Generated Style Ads at Scale

**Slug:** `ai-ugc-video-ad-factory`  
**Category:** Paid Advertising / Video Production  
**Powered by:** [Apify](https://www.apify.com?fpr=dx06p) + [InVideo AI](https://invideo.sjv.io/TBB) + Claude AI

> Input any product. Get **fully produced UGC-style video ads** — competitor ads analyzed, winning scripts written, authentic-feeling videos produced with AI voiceover & real-world visuals, and exported ready for Facebook, TikTok & Instagram. The #1 converting ad format. At $0 creator cost.

---

## 💥 Why This Skill Will Be Your Biggest Hit on ClawHub

UGC (User-Generated Content) style ads are the **#1 highest-converting ad format** on Meta, TikTok and Instagram right now. Brands pay real UGC creators **$150–$500 per video**. Top agencies charge **$2,000–$5,000 per UGC campaign**.

This skill produces the same quality output — fully scripted, fully produced — for **under $2 per video.**

Every e-commerce brand, Shopify store, SaaS company, app, and marketing agency on earth needs this. That's your entire audience.

**What gets automated:**
- 🕵️ Scrape **top performing UGC ads** in your niche from Meta Ad Library & TikTok
- 🧠 Reverse-engineer **hooks, scripts & structures** that make UGC convert
- ✍️ Generate **5 UGC scripts** per product — each with a different angle & persona
- 🎬 Produce **fully edited UGC-style videos** via InVideo AI — authentic feel, no studio
- 🎭 Create **multiple persona variations** — happy customer, skeptic converted, expert review
- 📊 Package everything into a **ready-to-launch ad campaign** with testing strategy

---

## 🛠️ Tools Used

| Tool | Purpose |
|---|---|
| [Apify](https://www.apify.com?fpr=dx06p) — Meta Ad Library Scraper | Scrape top UGC ads running in your niche |
| [Apify](https://www.apify.com?fpr=dx06p) — TikTok Creative Center Scraper | Top performing TikTok UGC ad creatives |
| [Apify](https://www.apify.com?fpr=dx06p) — Amazon Reviews Scraper | Real customer language & pain points for scripts |
| [Apify](https://www.apify.com?fpr=dx06p) — Reddit Scraper | Authentic buyer concerns & objections |
| [Apify](https://www.apify.com?fpr=dx06p) — Google Search Scraper | Competitor claims, testimonials, product positioning |
| [InVideo AI](https://invideo.sjv.io/TBB) | Produce authentic UGC-style videos with AI voiceover & visuals |
| Claude AI | Script writing, persona creation, angle strategy, A/B hooks |

---

## ⚙️ Full Workflow

```
INPUT: Product name + URL + target audience + platform + competitor brands
        ↓
STEP 1 — Competitor UGC Ad Intelligence
  └─ Meta Ad Library: top UGC ads in your niche (30+ days running = winner)
  └─ TikTok Creative Center: viral UGC product ads by category
  └─ Detect: hooks used, persona types, video length, CTA style
        ↓
STEP 2 — Voice of Customer Mining
  └─ Amazon reviews: real buyer language, before/after, specific results
  └─ Reddit: raw objections, fears, desires of your target audience
  └─ Extract: exact phrases buyers use → fuel for authentic scripts
        ↓
STEP 3 — Winning UGC Angles Identified
  └─ Problem/Solution: "I struggled with X until I found this"
  └─ Skeptic Converted: "I didn't believe it would work but..."
  └─ Expert/Authority: "As a [profession], here's why I recommend..."
  └─ Social Proof: "I've tried everything. This is the only thing that..."
  └─ Results-First: "I lost 12 lbs in 30 days. Here's exactly what I used."
        ↓
STEP 4 — Claude AI Writes 5 Full UGC Scripts
  └─ Each script = different persona + different angle
  └─ Hook (0–3 sec): scroll-stopper, pattern interrupt
  └─ Body (3–25 sec): story, proof, specific detail
  └─ CTA (25–30 sec): clear, urgent, benefit-led
  └─ 2 hook variations per script (A/B ready)
        ↓
STEP 5 — InVideo AI Produces All 5 Videos
  └─ 9:16 vertical format (TikTok / Reels / Stories)
  └─ AI voiceover — casual, authentic, NOT corporate
  └─ Real-world B-roll visuals matching the script
  └─ Minimal editing style (feels like real UGC, not an ad)
  └─ Captions synced for silent viewing
  └─ Export: MP4 1080p per platform
        ↓
STEP 6 — Campaign Launch Strategy
  └─ Which 2 scripts to test first (based on competitor data)
  └─ Budget split recommendation
  └─ KPI benchmarks from niche data
        ↓
OUTPUT: 5 UGC scripts + 5 produced videos + A/B hooks + campaign strategy
```

---

## 📥 Inputs

```json
{
  "product": {
    "name": "SleepEase — Natural Sleep Supplement",
    "url": "sleepeasy.com",
    "category": "Health & Wellness",
    "price": "$39.99",
    "usp": "Falls asleep in 20 minutes, no grogginess next day, 100% natural",
    "target_audience": "Adults 30-55 with stress-related sleep issues"
  },
  "competitors": ["Calm Sleep", "ZzzQuil", "MidNite Sleep"],
  "platforms": ["facebook", "instagram", "tiktok"],
  "ugc_style": "authentic_handheld",
  "videos_count": 5,
  "production": {
    "invideo_api_key": "YOUR_INVIDEO_API_KEY",
    "voice_options": ["relatable_female_30s", "authentic_male_40s"],
    "caption_style": "bold_bottom"
  },
  "apify_token": "YOUR_APIFY_TOKEN"
}
```

---

## 📤 Output Example

```json
{
  "competitive_intelligence": {
    "top_ugc_angles_in_niche": [
      { "angle": "Before/After transformation", "share": "41% of winning ads", "avg_runtime": "67 days" },
      { "angle": "Skeptic converted", "share": "29% of winning ads", "avg_runtime": "54 days" },
      { "angle": "Doctor/Expert endorsement style", "share": "18% of winning ads", "avg_runtime": "43 days" }
    ],
    "winning_hooks_detected": [
      "I've struggled with sleep for 7 years. This changed everything in week 1.",
      "POV: It's 2AM and you're still wide awake for the third night in a row...",
      "I was so skeptical when my friend recommended this. Then I tried it."
    ],
    "optimal_video_length": "28-35 seconds",
    "best_cta": "Shop now — first order ships free"
  },
  "voice_of_customer": {
    "top_pain_points": [
      "Lie awake for hours even when exhausted",
      "Wake up at 3AM and can't get back to sleep",
      "Prescription sleep aids leave me foggy all day",
      "Stress at work is destroying my sleep"
    ],
    "top_desires": [
      "Fall asleep fast without feeling drugged",
      "Wake up actually refreshed",
      "Something natural that actually works",
      "Stop dreading bedtime"
    ],
    "exact_buyer_phrases": [
      "finally something that works",
      "I was so skeptical",
      "wish I found this sooner",
      "no more staring at the ceiling"
    ]
  },
  "ugc_scripts": [
    {
      "script_id": 1,
      "persona": "Exhausted Working Mom, 38",
      "angle": "Problem → Solution → Results",
      "performance_prediction": "🔥 Highest priority to test — matches #1 winning angle in niche",
      "hook": "I haven't slept through the night in 4 years. Until 3 weeks ago.",
      "hook_variation_b": "POV: It's 2AM. You're exhausted. But your brain won't stop.",
      "full_script": "Hook (0:00-0:03):\n'I haven't slept through the night in 4 years. Until 3 weeks ago.'\n\nBody (0:03-0:25):\n'Between the kids, work, and just... life — I was running on 4 hours a night. I tried melatonin. Magnesium. All of it. Nothing worked.\n\nMy sister kept telling me to try SleepEase. I ignored her for months because honestly, I'd given up.\n\nFinally tried it on a Thursday night. Fell asleep before 11PM. Slept until 6:30.\n\nI literally cried when I woke up.\n\nIt's been 3 weeks. I've slept through the night 19 out of 21 days. I feel like myself again.'\n\nCTA (0:25-0:30):\n'Link in bio — they're doing free shipping on first orders right now. Don't wait like I did.'",
      "production_notes": "Handheld style. Bedroom setting, morning light. Casual clothes. No makeup perfection. Real = relatable.",
      "invideo_production": {
        "status": "produced",
        "duration": "30s",
        "format": "9:16 vertical",
        "voice": "relatable_female_30s",
        "captions": true,
        "video_file": "outputs/ugc_ad_01_exhausted_mom.mp4"
      }
    },
    {
      "script_id": 2,
      "persona": "Skeptical Professional, 44",
      "angle": "Skeptic Converted",
      "performance_prediction": "⚡ Strong second test — skeptic angle builds trust fast",
      "hook": "I'm not someone who buys supplements. I thought this was a scam.",
      "hook_variation_b": "Okay I need to talk about this because I genuinely didn't believe it would work.",
      "full_script": "Hook (0:00-0:03):\n'I'm not someone who buys supplements. I thought this was a scam.'\n\nBody (0:03-0:25):\n'My doctor literally suggested I try SleepEase before going back on prescription sleep meds. I rolled my eyes.\n\nBut I was desperate. 5 hours a night for 8 months. Affecting my work, my relationships, everything.\n\nI did my research. The ingredients actually check out — no melatonin dependency, no next-day brain fog.\n\nWeek one: fell asleep 40 minutes faster on average. Week two: started waking up before my alarm.\n\nI'm not saying it works for everyone. I'm saying it worked for me when nothing else did.'\n\nCTA (0:25-0:30):\n'They have a money-back guarantee so there's literally zero risk. Link's in my bio.'",
      "invideo_production": {
        "status": "produced",
        "duration": "30s",
        "format": "9:16 vertical",
        "voice": "authentic_male_40s",
        "video_file": "outputs/ugc_ad_02_skeptic.mp4"
      }
    },
    {
      "script_id": 3,
      "persona": "Wellness Enthusiast, 32",
      "angle": "Expert Authority / Ingredient Deep Dive",
      "hook": "As someone obsessed with sleep science, here's why SleepEase actually works.",
      "full_script": "Hook (0:00-0:03):\n'As someone obsessed with sleep science, here's why SleepEase actually works — and why most sleep supplements don't.'\n\nBody (0:03-0:25):\n'Most supplements just dump melatonin into a pill. Problem? Your body stops making its own. You become dependent.\n\nSleepEase uses a different approach — Ashwagandha to lower cortisol, L-Theanine to calm the mind, and Magnesium Glycinate to relax the body. No melatonin. No dependency.\n\nI've tried 11 different sleep supplements in the last 3 years. This is the only one where I wake up feeling genuinely rested — not groggy, not foggy. Rested.'\n\nCTA (0:25-0:30):\n'Link in bio. First order ships free and there's a 60-day guarantee. Worth trying.'",
      "invideo_production": {
        "status": "produced",
        "duration": "30s",
        "format": "9:16 vertical",
        "video_file": "outputs/ugc_ad_03_expert.mp4"
      }
    }
  ],
  "campaign_strategy": {
    "testing_order": [
      { "priority": 1, "script": 1, "why": "Before/after + emotional story = highest converting angle in niche" },
      { "priority": 2, "script": 2, "why": "Skeptic converted builds trust — great for cold audiences" },
      { "priority": 3, "script": 3, "why": "Authority angle — test once you have a winning hook" }
    ],
    "budget_split": "$30/day per script for first 5 days. Kill bottom performer. Scale winner.",
    "kpi_benchmarks": {
      "hook_rate_target": "Aim for 30%+ of viewers watching past 3 seconds",
      "ctr_benchmark": "1.5-3% for health supplements on Meta",
      "cpa_target": "Under $18 for a $39.99 product to hit 2x ROAS minimum"
    },
    "a_b_test_plan": "Run hook variation A vs B for script 1 simultaneously. Same budget. Winner takes all after 72 hours."
  }
}
```

---

## 🧠 Claude AI Master Prompt

```
You are a world-class UGC ad scriptwriter and direct response copywriter.

COMPETITOR UGC AD DATA:
{{competitor_ugc_ads}}

VOICE OF CUSTOMER DATA:
- Real pain points: {{pain_points}}
- Real desires: {{desires}}
- Exact buyer phrases: {{buyer_phrases}}

PRODUCT:
- Name: {{product_name}}
- USP: {{usp}}
- Price: {{price}}
- Audience: {{target_audience}}

FOR EACH OF THE 5 UGC SCRIPTS GENERATE:
1. Persona (age, situation, identity — specific and relatable)
2. Angle (Problem/Solution / Skeptic Converted / Expert / Results-First / Social Proof)
3. Performance prediction based on competitor data
4. Hook (0-3 seconds — scroll stopper. Must feel REAL, not like an ad)
5. Hook variation B (alternative for A/B test)
6. Full script with timestamps:
   - Hook (0-3s): Pattern interrupt. Emotional or curiosity trigger.
   - Body (3-25s): Story. Specific details. Real language. No corporate speak.
   - CTA (25-30s): Clear. Urgent. Benefit-led. One action only.
7. Production notes (setting, vibe, visual style for InVideo)

GOLDEN RULES FOR UGC SCRIPTS:
- Sounds like a real person talking to a friend, NOT an ad
- Specific details beat vague claims ("19 out of 21 nights" > "most nights")
- Use EXACT buyer phrases mined from reviews and Reddit
- Never say "game-changer", "amazing", "incredible" — too salesy
- The hook must work in the first 2 seconds with sound OFF (captions do the work)

OUTPUT: Valid JSON only. No markdown. No preamble.
```

---

## 💰 Cost Estimate

| Videos | Apify Cost | InVideo Cost | Total | Value if Outsourced |
|---|---|---|---|---|
| 5 UGC videos | ~$0.50 | ~$8 | ~$8.50 | $750–$2,500 |
| 10 UGC videos | ~$0.90 | ~$15 | ~$15.90 | $1,500–$5,000 |
| 25 UGC videos | ~$2.10 | ~$35 | ~$37.10 | $3,750–$12,500 |
| 50 UGC videos | ~$4.00 | ~$65 | ~$69 | $7,500–$25,000 |

> 💡 **Get started free on [Apify](https://www.apify.com?fpr=dx06p) — $5 credits included**

> 🎬 **Produce all your UGC videos with [InVideo AI](https://invideo.sjv.io/TBB) — free plan available**

---

## 🔗 Who Prints Money With This Skill

| User | How They Use It | Revenue |
|---|---|---|
| **UGC Agency** | Sell 5-video packs to brands | $1,500–$5,000 per pack |
| **Media Buyer** | Test 5 angles simultaneously — find winner fast | 3x faster path to profitable ads |
| **E-commerce Brand** | Replace $500/creator UGC with $8.50 AI version | Save $10K+/month |
| **Shopify Store** | Launch new product with 5 tested ad angles | Profitable from day 1 |
| **Marketing Freelancer** | Offer UGC ad service as premium package | Add $2K–$5K per client |
| **App Developer** | Generate authentic-feeling app review ads | Cut CAC by 40–60% |

---

## 📊 Why This Skill Is in a League of Its Own

| Feature | Hiring UGC Creators | **AI UGC Video Ad Factory** |
|---|---|---|
| Cost per video | $150–$500 | ~$1.70 |
| Turnaround time | 5–14 days | Under 10 minutes |
| Competitor ad analysis | ❌ | ✅ |
| Voice of customer research | ❌ | ✅ |
| 5 angles tested simultaneously | ❌ | ✅ |
| A/B hook variations | ❌ | ✅ |
| Campaign strategy included | ❌ | ✅ |
| Scale to 50 videos in one run | ❌ | ✅ |

---

## 🚀 Setup in 3 Steps

**Step 1 — Get your [Apify](https://www.apify.com?fpr=dx06p) API Token**  
Go to: **Settings → Integrations → API Token**

**Step 2 — Get your [InVideo AI](https://invideo.sjv.io/TBB) account**  
Go to: **Settings → API → Copy your key**

**Step 3 — Input your product & run**  
Product URL + competitors + target audience. 5 UGC videos ready in under 10 minutes.

---

## ⚡ Pro Tips to Get Winning UGC Ads Faster

- **Always test the skeptic angle** — it builds the most trust with cold audiences
- **Specific numbers 10x credibility** — "19 out of 21 nights" beats "most nights" every time
- **Hook with sound OFF** — 85% of people scroll with sound off. Captions carry the hook.
- **Run all 5 angles simultaneously** — $30/day each for 5 days. Let data pick the winner.
- **Winning UGC ad = run it for 90 days minimum** — don't kill it when it's working
- **Reuse your best script with different voices** — same script, different AI voice = new creative

---

## 🏷️ Tags

`ugc` `video-ads` `facebook-ads` `tiktok-ads` `instagram-ads` `ad-creative` `apify` `invideo` `ecommerce` `performance-marketing` `direct-response` `shopify`

---

*Powered by [Apify](https://www.apify.com?fpr=dx06p) + [InVideo AI](https://invideo.sjv.io/TBB) + Claude AI*
