# 💹 AI Stock & Crypto Market Scanner — Spot Opportunities Before the Crowd

**Slug:** `ai-stock-crypto-scanner`  
**Category:** Finance / Trading Intelligence  
**Powered by:** [Apify](https://www.apify.com?fpr=dx06p) + [3Commas](https://3commas.io/?utm_source=referral&utm_medium=cabinet&c=SKL) + [InVideo AI](https://invideo.sjv.io/TBB) + Claude AI

> Input your watchlist or market sector. Get a **complete market intelligence report** — price action analyzed, sentiment scraped from Reddit & Twitter, insider signals detected, AI opportunity scores generated, and automated trading bots deployed via 3Commas. All in one run.

---

## 💥 Why This Skill Will Explode on ClawHub

Every retail trader, crypto investor, and finance enthusiast is constantly looking for the next opportunity — before it's too late. Professional hedge funds spend **millions on Bloomberg terminals and sentiment tools**. This skill delivers the same intelligence for under $2.

**Target audience:** Day traders, swing traders, crypto investors, DeFi enthusiasts, financial advisors, fintech startups, trading educators. That's hundreds of millions of people globally.

**What gets automated:**
- 📊 Scrape **real-time price action** signals across stocks & crypto
- 🐦 Monitor **Reddit (WallStreetBets, r/CryptoCurrency) & Twitter/X** for sentiment surges
- 📰 Detect **news catalysts** — earnings, partnerships, regulatory moves
- 🐋 Spot **whale movements** — large wallet transfers & unusual volume
- 🤖 Deploy **automated trading bots** via [3Commas](https://3commas.io/?utm_source=referral&utm_medium=cabinet&c=SKL) based on AI signals
- 🎬 Produce **daily market briefing video** via [InVideo AI](https://invideo.sjv.io/TBB)
- 📋 Deliver a **ranked opportunity list** with entry/exit suggestions

> ⚠️ **Disclaimer:** This skill provides market intelligence and analysis for informational purposes only. Nothing in this output constitutes financial advice. Always do your own research before trading.

---

## 🛠️ Tools Used

| Tool | Purpose |
|---|---|
| [Apify](https://www.apify.com?fpr=dx06p) — Google Finance Scraper | Price data, volume, market cap movements |
| [Apify](https://www.apify.com?fpr=dx06p) — Reddit Scraper | WallStreetBets, r/CryptoCurrency sentiment surges |
| [Apify](https://www.apify.com?fpr=dx06p) — Twitter/X Scraper | Viral mentions, influencer signals, trending tickers |
| [Apify](https://www.apify.com?fpr=dx06p) — Google News Scraper | Earnings news, partnerships, regulatory updates |
| [Apify](https://www.apify.com?fpr=dx06p) — CoinGecko Scraper | Crypto price action, volume spikes, new listings |
| [3Commas](https://3commas.io/?utm_source=referral&utm_medium=cabinet&c=SKL) | Deploy automated trading bots based on AI signals |
| [InVideo AI](https://invideo.sjv.io/TBB) | Produce daily 60-second market briefing video |
| Claude AI | Signal scoring, opportunity ranking, risk analysis |

---

## ⚙️ Full Workflow

```
INPUT: Watchlist (tickers/coins) + sector + risk profile + trading style
        ↓
STEP 1 — Price Action & Volume Analysis
  └─ % change (1h / 24h / 7d / 30d)
  └─ Volume spike detection (3x+ average = signal)
  └─ Support & resistance levels
  └─ RSI, MACD signals (overbought/oversold)
        ↓
STEP 2 — Sentiment Scan (Reddit + Twitter/X)
  └─ Mention volume surge (10x+ normal = crowd forming)
  └─ Sentiment score: bullish / neutral / bearish / panic
  └─ Key influencer mentions detected
  └─ Viral posts & threads about this asset
        ↓
STEP 3 — News Catalyst Detection
  └─ Earnings reports (beat / miss / upcoming)
  └─ Partnership announcements
  └─ Regulatory news (positive or negative)
  └─ Insider buying/selling signals
        ↓
STEP 4 — Whale & On-Chain Signals (Crypto)
  └─ Large wallet transfers detected
  └─ Exchange inflows/outflows
  └─ New whale accumulation patterns
        ↓
STEP 5 — AI Opportunity Scoring (0–100)
  └─ Combines: price momentum + sentiment + news + volume
  └─ Risk-adjusted score based on your profile
  └─ Label: 🔥 Strong Signal / ⚡ Watch / ❄️ Avoid
        ↓
STEP 6 — 3Commas Bot Deployment
  └─ Auto-configure DCA bot for top opportunities
  └─ Set entry, take profit & stop loss based on AI signals
  └─ Risk-capped per your profile settings
        ↓
STEP 7 — InVideo AI Produces Daily Briefing Video
  └─ 60-second "Markets Today" summary video
  └─ Top 3 opportunities + 1 risk to watch
  └─ Perfect for YouTube Shorts, TikTok, newsletter
        ↓
OUTPUT: Ranked opportunity report + bot configs + daily briefing video
```

---

## 📥 Inputs

```json
{
  "watchlist": {
    "stocks": ["NVDA", "TSLA", "PLTR", "SMCI"],
    "crypto": ["BTC", "ETH", "SOL", "PEPE"],
    "sectors": ["AI & semiconductors", "DeFi", "memecoins"]
  },
  "trader_profile": {
    "style": "swing trader",
    "risk_level": "medium",
    "capital_per_trade": 1000,
    "holding_period": "3-14 days",
    "exchanges": ["Binance", "Coinbase"]
  },
  "alerts": {
    "sentiment_surge_threshold": "5x normal mention volume",
    "volume_spike_threshold": "3x 30-day average",
    "price_change_alert": "5%+ in 4 hours"
  },
  "automation": {
    "threecommas_api_key": "YOUR_3COMMAS_API_KEY",
    "auto_deploy_bots": true,
    "max_concurrent_bots": 3,
    "invideo_api_key": "YOUR_INVIDEO_API_KEY"
  },
  "apify_token": "YOUR_APIFY_TOKEN"
}
```

---

## 📤 Output Example

```json
{
  "scan_summary": {
    "date": "2026-03-03",
    "assets_scanned": 8,
    "strong_signals": 2,
    "watch_list": 3,
    "avoid": 3,
    "market_sentiment": "⚡ Cautiously Bullish — crypto momentum building, stocks mixed"
  },
  "opportunities": [
    {
      "rank": 1,
      "asset": "SOL (Solana)",
      "type": "Crypto",
      "opportunity_score": 91,
      "signal_label": "🔥 Strong Signal",
      "price_data": {
        "current_price": "$148.20",
        "change_24h": "+8.4%",
        "change_7d": "+22.1%",
        "volume_spike": "4.2x 30-day average",
        "rsi_14": 62,
        "rsi_signal": "Bullish — not yet overbought"
      },
      "sentiment": {
        "reddit_mentions_24h": 4847,
        "vs_7day_avg": "+380%",
        "sentiment_score": "82% Bullish",
        "top_reddit_post": "r/CryptoCurrency: 'Solana ETF filing confirmed — this changes everything' (12K upvotes)",
        "twitter_mentions_24h": 28400,
        "key_influencer": "@CryptoKaleo mentioned SOL as his top pick for Q1"
      },
      "news_catalysts": [
        "🟢 Solana ETF filing submitted to SEC — first major catalyst in 6 months",
        "🟢 Visa partnership expansion announced — real-world adoption signal",
        "⚪ Minor network outage 48 hours ago — resolved, no lasting impact"
      ],
      "whale_signals": {
        "large_transfers": "3 wallets moved 50K+ SOL to cold storage in last 12 hours",
        "exchange_flow": "Net outflow from exchanges (-$42M) — accumulation signal",
        "verdict": "🐋 Whales accumulating — bullish"
      },
      "ai_analysis": "SOL is showing a rare confluence of 4 bullish signals simultaneously: volume spike, sentiment surge, positive news catalyst, and whale accumulation. The ETF news is the primary driver. Risk: if SEC rejects, expect 20-30% correction. Risk/reward favors entry at current levels for swing traders.",
      "suggested_trade": {
        "entry_zone": "$144–$150",
        "take_profit_1": "$168 (+13%)",
        "take_profit_2": "$195 (+31%)",
        "stop_loss": "$132 (-11%)",
        "risk_reward_ratio": "2.8:1",
        "position_size": "$1,000 (per your risk profile)"
      },
      "threecommas_bot": {
        "type": "DCA Bot",
        "status": "deployed",
        "config": {
          "base_order": "$400",
          "safety_orders": 3,
          "safety_order_size": "$200",
          "take_profit": "13%",
          "stop_loss": "11%",
          "start_condition": "Price drops to $144"
        }
      }
    },
    {
      "rank": 2,
      "asset": "NVDA (Nvidia)",
      "type": "Stock",
      "opportunity_score": 84,
      "signal_label": "🔥 Strong Signal",
      "price_data": {
        "current_price": "$892.40",
        "change_24h": "+3.2%",
        "volume_spike": "2.8x average"
      },
      "news_catalysts": [
        "🟢 Earnings report in 6 days — consensus expects 40% YoY growth",
        "🟢 New AI chip partnership with Microsoft announced"
      ],
      "ai_analysis": "Pre-earnings momentum with strong institutional buying. High conviction swing trade opportunity into earnings. Consider reducing position after earnings announcement regardless of outcome.",
      "suggested_trade": {
        "entry_zone": "$880–$900",
        "take_profit_1": "$950 (+6.5%)",
        "stop_loss": "$850 (-4.7%)",
        "risk_reward_ratio": "1.4:1"
      }
    }
  ],
  "risk_warnings": [
    {
      "asset": "PEPE",
      "signal": "❄️ Avoid",
      "reason": "Negative sentiment surge — 67% bearish mentions. Whale dumping detected. 3 influencers called exit.",
      "action": "Do not enter. If holding, consider reducing exposure."
    }
  ],
  "daily_briefing_video": {
    "script": "Markets today — March 3rd 2026. Two strong signals on our radar. Solana is up 8% on ETF filing news with whale accumulation confirming the move. Nvidia approaching earnings with institutional momentum. Our AI scanner scores both as high conviction opportunities. One to avoid: PEPE showing whale distribution signals. Full analysis in the report. Trade smart.",
    "duration": "60s",
    "status": "produced",
    "video_file": "outputs/market_briefing_march03.mp4"
  }
}
```

---

## 🧠 Claude AI Master Prompt

```
You are a world-class quantitative analyst and trading intelligence specialist.

PRICE & VOLUME DATA:
{{price_action_data}}

SENTIMENT DATA (Reddit + Twitter):
{{sentiment_data}}

NEWS CATALYSTS:
{{news_data}}

WHALE/ON-CHAIN DATA:
{{onchain_data}}

TRADER PROFILE:
- Style: {{trading_style}}
- Risk level: {{risk_level}}
- Capital per trade: ${{capital}}
- Holding period: {{holding_period}}

FOR EACH ASSET GENERATE:
1. Opportunity score (0–100) combining:
   - Price momentum (25%)
   - Volume signal (20%)
   - Sentiment score (25%)
   - News catalyst strength (20%)
   - Whale/institutional signal (10%)
2. Signal label: Strong Signal / Watch / Avoid
3. Plain-English AI analysis (3-4 sentences, no jargon)
4. Suggested trade: entry zone, 2 take profit levels, stop loss, R/R ratio
5. 3Commas bot config for top 2 signals only
6. 60-second daily briefing video script

RISK RULES:
- Never suggest more than 10% portfolio in single trade
- Flag any asset with negative news + falling volume as Avoid
- Always include stop loss — no exceptions

DISCLAIMER: Include in every response that this is for informational
purposes only and does not constitute financial advice.

OUTPUT: Valid JSON only. No markdown. No preamble.
```

---

## 💰 Cost Estimate

| Scans | Apify Cost | InVideo Cost | Total | Pro Tool Equivalent |
|---|---|---|---|---|
| 1 daily scan | ~$0.40 | ~$3 | ~$3.40 | Bloomberg: $2,000/month |
| Weekly (7 scans) | ~$2.80 | ~$21 | ~$23.80 | Sentiment tools: $500/month |
| Monthly (30 scans) | ~$12 | ~$90 | ~$102 | Total saved: $2,400/month |

> 💡 **Get started free on [Apify](https://www.apify.com?fpr=dx06p) — $5 credits included**

> 🤖 **Automate your trades with [3Commas](https://3commas.io/?utm_source=referral&utm_medium=cabinet&c=SKL) — free plan available**

> 🎬 **Produce your daily briefing with [InVideo AI](https://invideo.sjv.io/TBB) — free plan available**

---

## 🔗 Who Wins Big With This Skill

| User | How They Use It | Value |
|---|---|---|
| **Retail Trader** | Daily AI-powered market scan before trading | Better entry timing |
| **Crypto Investor** | Detect whale moves & sentiment before price reacts | Early mover advantage |
| **Finance Content Creator** | Daily briefing video for YouTube/TikTok audience | Monetize trading knowledge |
| **Trading Educator** | Deliver weekly market intelligence to students | Premium course add-on |
| **Fintech Startup** | Power a market intelligence product | B2B SaaS revenue stream |
| **Financial Advisor** | Supplement research with AI sentiment layer | Save 5+ hours/week |

---

## 📊 Why This Replaces $2,000+/Month Tools

| Feature | Bloomberg Terminal | Santiment ($500/mo) | **This Skill** |
|---|---|---|---|
| Price & volume data | ✅ | ✅ | ✅ |
| Reddit sentiment analysis | ❌ | ✅ | ✅ |
| Twitter/X sentiment | ❌ | ✅ | ✅ |
| AI opportunity scoring | ❌ | ❌ | ✅ |
| Auto bot deployment | ❌ | ❌ | ✅ |
| Daily video briefing | ❌ | ❌ | ✅ |
| Entry/exit suggestions | ❌ | ❌ | ✅ |
| Monthly cost | $2,000+ | $500 | ~$102 |

---

## 🚀 Setup in 3 Steps

**Step 1 — Get your [Apify](https://www.apify.com?fpr=dx06p) API Token**  
Go to: **Settings → Integrations → API Token**

**Step 2 — Connect [3Commas](https://3commas.io/?utm_source=referral&utm_medium=cabinet&c=SKL)**  
Create free account → Go to: **My Profile → API → Generate Key**

**Step 3 — Get your [InVideo AI](https://invideo.sjv.io/TBB) account**  
Go to: **Settings → API → Copy your key**

---

## ⚡ Pro Tips to Trade Smarter With This Skill

- **Never trade on sentiment alone** — always wait for price confirmation before entry
- **Volume spike + sentiment surge together = highest conviction signal**
- **Set your 3Commas bots on Sunday night** — markets move fast Monday morning
- **Your daily briefing video = best trading content on TikTok** — post it every day, build an audience
- **Always honor your stop loss** — the bot does it automatically, don't override it manually

> ⚠️ **Important:** Past performance does not guarantee future results. This tool provides market intelligence for research purposes only. Never invest more than you can afford to lose.

---

## 🏷️ Tags

`trading` `crypto` `stocks` `market-scanner` `sentiment-analysis` `apify` `3commas` `invideo` `trading-bot` `bitcoin` `defi` `finance`

---

*Powered by [Apify](https://www.apify.com?fpr=dx06p) + [3Commas](https://3commas.io/?utm_source=referral&utm_medium=cabinet&c=SKL) + [InVideo AI](https://invideo.sjv.io/TBB) + Claude AI*
