---
name: intellectia-stock-screener
description: Intellectia stock/crypto screener for Bullish/Bearish Tomorrow/Week/Month presets. Calls /gateway/v1/stock/screener-list (no auth) and summarizes results.
metadata: {"openclaw":{"requires":{"bins":["curl","python3"]},"install":[{"id":"python","kind":"pip","package":"requests","bins":[],"label":"Install requests (pip)"}]}}
---

# Intellectia Stock Screener

Fetch and summarize Intellectia “Screener List” results for stock/crypto screening.

## When to use this skill

Use this skill when you want to:
- Get the latest **bullish/bearish** screener candidates for **stocks** or **crypto**
- Use the built-in **preset pick-lists** (below) as your “stock/crypto picking tools”
- Convert a preset into exact API query parameters (`symbol_type`, `period_type`, `trend_type`)
- Summarize/compare results using `probability`, `profit`, `price`, `change_ratio`, `klines`, and `trend_list`

## Presets (UI list mapping)

Pick one preset name and run it (this is the easiest way to use the skill):

| Preset (UI name) | symbol_type | period_type | trend_type |
|---|---:|---:|---:|
| Stocks Bullish Tomorrow | 0 | 0 | 0 |
| Stocks Bearish Tomorrow | 0 | 0 | 1 |
| Stocks Bullish for a Week | 0 | 1 | 0 |
| Stocks Bearish for a Week | 0 | 1 | 1 |
| Stocks Bullish for a Month | 0 | 2 | 0 |
| Stocks Bearish for a Month | 0 | 2 | 1 |
| Cryptos Bullish Tomorrow | 2 | 0 | 0 |
| Cryptos Bearish Tomorrow | 2 | 0 | 1 |
| Cryptos Bullish for a Week | 2 | 1 | 0 |
| Cryptos Bearish for a Week | 2 | 1 | 1 |
| Cryptos Bullish for a Month | 2 | 2 | 0 |
| Cryptos Bearish for a Month | 2 | 2 | 1 |

### Preset descriptions (copy-ready)

- **Stocks Bullish Tomorrow**: This list highlights stocks expected to rise, identified by our AI algorithm. It analyzes market-wide price data to spot those most likely to continue an uptrend, based on similarity to proven bullish patterns.
- **Stocks Bearish Tomorrow**: This list highlights stocks expected to fall, identified by our AI algorithm. It analyzes market-wide price data to spot those most likely to continue a downtrend, based on similarity to proven bearish patterns.

## How to ask (high hit-rate)

If you want OpenClaw to automatically pick this skill, include:
- The word **Intellectia** or **screener** (or “bullish/bearish”, “stock screener”, “crypto screener”)
- One **preset name** from the table above (recommended)
- Your output requirements (top N, sort, fields)

If you want to force it, use:
- `/skill intellectia-stock-screener <your request>`

Copy-ready prompts:
- “Intellectia screener: **Stocks Bullish Tomorrow**. Top 10 by `probability` desc. Output: `symbol,name,price,change_ratio,probability,profit`.”
- “Intellectia screener: **Stocks Bearish for a Week**. Explain what `probability` and `profit` mean, then return a table.”
- “Intellectia screener: **Cryptos Bullish for a Month**. Page 1 size 50. Filter `probability >= 70`.”
- “Call Intellectia `/gateway/v1/stock/screener-list` with `symbol_type=0 period_type=0 trend_type=0 page=1 size=20` and return raw JSON.”

## Tool configuration

| Tool | Purpose | Configuration |
|---|---|---|
| `curl` | Quick one-off requests | Use the full URL + query string |
| `python3` | Repeatable scripts | Use `requests` and parse `data.list` |
| `requests` | HTTP client library | `pip install requests` |

## Using this skill in OpenClaw

Install into the current workspace:

```bash
clawhub install intellectia-stock-screener
```

Start a **new OpenClaw session** so the agent picks it up (skills are snapshotted at session start).

Verify it is visible/eligible:

```bash
openclaw skills list
openclaw skills info intellectia-stock-screener
openclaw skills check
```

## Endpoint

- Base URL: `https://api.intellectia.ai`
- `GET /gateway/v1/stock/screener-list`

## Query parameters

| Name | Type | Meaning |
|---|---|---|
| `symbol_type` | int | Asset type: `0=stock 1=etf 2=crypto` |
| `period_type` | int | Period: `0=day 1=week 2=month` |
| `trend_type` | int | Trend: `0=bullish 1=bearish` |
| `profit_asc` | bool | Sort by profit ascending (`true` = small → large) |
| `market_cap` | int | Market cap filter: `0=any 1=micro(<300M) 2=small(300M-2B) 3=mid(2B-10B) 4=large(10B-200B) 5=mega(>200B)` |
| `price` | int | Price filter: `0=any 1=<5 2=<50 3=>5 4=>50 5=5-50` |
| `page` | int | Page number (example: 1) |
| `size` | int | Page size (example: 20) |

## Response (200)

Example response (shape):

```json
{
  "ret": 0,
  "msg": "",
  "data": {
    "list": [
      {
        "code": "BKD.N",
        "symbol": "BKD",
        "symbol_type": 0,
        "name": "Brookdale Senior Living Inc",
        "logo": "https://intellectia-public-documents.s3.amazonaws.com/image/logo/BKD_logo.png",
        "pre_close": 14.5,
        "price": 15,
        "change_ratio": 3.45,
        "timestamp": "1769749200",
        "simiar_num": 10,
        "probability": 80,
        "profit": 5.27,
        "klines": [{ "close": 15, "timestamp": "1769749200" }],
        "trend_list": [
          {
            "symbol": "BKD",
            "symbol_type": 0,
            "is_main": true,
            "list": [{ "change_ratio": 5.27, "timestamp": "1730260800", "close": 16 }]
          }
        ],
        "update_time": "1769806800"
      }
    ],
    "total": 3,
    "detail": {
      "cover_url": "https://d159e3ysga2l0q.cloudfront.net/image/cover_image/stock-1.png",
      "name": "Stocks Bullish Tomorrow",
      "screener_type": 1011,
      "params": "{}",
      "desc": "..."
    }
  }
}
```

### Field reference

Top-level:
- `ret` (int): Status code (typically `0` means success)
- `msg` (string): Message (empty string when OK)
- `data` (object): Payload

`data`:
- `data.list` (array): Result rows
- `data.total` (int): Total number of rows
- `data.detail` (object): Screener metadata

Each item in `data.list`:
- `code` (string): Full instrument code (may include exchange suffix, e.g. `BKD.N`)
- `symbol` (string): Ticker symbol (e.g. `BKD`)
- `symbol_type` (int): Asset type (`0=stock 1=etf 2=crypto`)
- `name` (string): Display name
- `logo` (string): Logo URL
- `pre_close` (number): Previous close price
- `price` (number): Current price
- `change_ratio` (number): Percent change vs previous close
- `timestamp` (string): Quote timestamp (Unix seconds)
- `simiar_num` (int): Similarity count (as returned by API; spelling kept as-is)
- `probability` (int): Model confidence (0-100)
- `profit` (number): Predicted/expected return (as returned by API)
- `klines` (array): Price series
  - `klines[].close` (number): Close price
  - `klines[].timestamp` (string): Unix seconds
- `trend_list` (array): Trend comparison series
  - `trend_list[].symbol` (string): Symbol for the series (may be empty for non-main series)
  - `trend_list[].symbol_type` (int): Asset type
  - `trend_list[].is_main` (bool): Whether this is the main series
  - `trend_list[].list` (array): Time points
    - `trend_list[].list[].change_ratio` (number): Percent change at that point
    - `trend_list[].list[].timestamp` (string): Unix seconds
    - `trend_list[].list[].close` (number): Close price at that point
- `update_time` (string): Last update time (Unix seconds)

`data.detail`:
- `cover_url` (string): Cover image URL
- `name` (string): Screener title
- `screener_type` (int): Screener type ID
- `params` (string): Serialized params (often JSON string)
- `desc` (string): Screener description
- `num` (int, optional): As returned by API (may be absent)

## Examples

### cURL

```bash
curl -sS "https://api.intellectia.ai/gateway/v1/stock/screener-list?symbol_type=0&period_type=0&trend_type=0&profit_asc=false&market_cap=0&price=0&page=1&size=20"
```

### Python (requests)

```bash
python3 - <<'PY'
import requests

base_url = "https://api.intellectia.ai"
params = {
  "symbol_type": 0,
  "period_type": 0,
  "trend_type": 0,
  "profit_asc": False,
  "market_cap": 0,
  "price": 0,
  "page": 1,
  "size": 20,
}

r = requests.get(f"{base_url}/gateway/v1/stock/screener-list", params=params, timeout=30)
r.raise_for_status()
payload = r.json()

print("ret:", payload.get("ret"))
print("msg:", payload.get("msg"))
data = payload.get("data") or {}
rows = data.get("list") or []
print("total:", data.get("total"))
for row in rows[:10]:
  print(row.get("symbol"), row.get("price"), row.get("change_ratio"), row.get("probability"), row.get("profit"))
PY
```

## Notes

- No authentication required.
- If you see rate limits, reduce `size` and add backoff/retry in client code.
