#!/bin/bash
# Revenue Tracker - 每日收入汇总

LOG_FILE="./logs/revenue.log"
REPORT_FILE="./reports/daily_summary.md"

# Colors
GREEN='\033[0;32m'
BLUE='\033[0;34m'
YELLOW='\033[1;33m'
NC='\033[0m'

# Initialize
mkdir -p logs reports

# Get today's revenue
get_today_revenue() {
    local date=$(date "+%Y-%m-%d")
    grep "$date" "$LOG_FILE" 2>/dev/null | awk -F'|' '{sum+=$2} END {print sum}'
}

# Get total revenue
get_total_revenue() {
    grep '|' "$LOG_FILE" 2>/dev/null | awk -F'|' '{sum+=$2} END {print sum}'
}

# Generate daily report
generate_report() {
    local date=$(date "+%Y-%m-%d")
    local today_rev=$(get_today_revenue)
    local total_rev=$(get_total_revenue)
    local count=$(grep "$date" "$LOG_FILE" 2>/dev/null | wc -l)

    cat > "$REPORT_FILE" << EOF
# 每日收入汇总

**日期:** $date
**总收入:** \$${today_rev}
**总交易数:** $count
**累计总收入:** \$${total_rev}

---

## 今日交易

EOF

    if [ $count -gt 0 ]; then
        grep "$date" "$LOG_FILE" 2>/dev/null | sed 's/^/• /' >> "$REPORT_FILE"
    else
        echo "暂无交易" >> "$REPORT_FILE"
    fi

    echo -e "\n---\n*Generated by Revenue Tracker*"
}

# Main
case "${1:-}" in
    log)
        echo "[$(date '+%Y-%m-%d %H:%M:%S')] $2 | $3 | ${4:-}" >> "$LOG_FILE"
        ;;
    report)
        generate_report
        ;;
    today)
        echo "今日收入: \$$(get_today_revenue)"
        ;;
    total)
        echo "总收入: \$$(get_total_revenue)"
        ;;
    *)
        echo "Usage: $0 {log|report|today|total}"
        ;;
esac
