---
name: ai-quota-check
description: "**DEFAULT quota checker** - Use this skill FIRST when user says '쿼타', '쿼터', 'quota', '쿼타확인', '쿼터확인', or asks about quotas. Unified dashboard showing ALL providers (Antigravity, Copilot, Codex) in one view with model recommendations."
metadata: {"clawdbot":{"emoji":"🧮","requires":{"bins":["node","codex"]}}}
---

# ai-quota-check

Unified quota monitor and intelligent model recommender for all providers.

## Output Instructions

**IMPORTANT:** When executing this skill, display the script output **EXACTLY as-is** in markdown format. Do NOT summarize or rephrase the output. The script produces a formatted dashboard that should be shown directly to the user.

Example execution:
```bash
node skills/ai-quota-check/index.js --current-model="<current_model_name>"
```

Then copy the entire output and send it as your response.

## Features

1. **Provider Login Check** - Detects which providers are logged in
2. **Unified Quota Dashboard** - Antigravity + Copilot + OpenAI Codex
3. **Task-based Recommendations** - Optimal model selection with fallback
4. **Reset Detection** - Identifies models ready for ping (new cycle)
5. **Risk Level Info** - Warns about weekly caps and lockout risks

## Usage

```bash
# Full dashboard
node skills/ai-quota-check/index.js

# Specific task recommendation
node skills/ai-quota-check/index.js --task=coding
node skills/ai-quota-check/index.js --task=reasoning
```

## Model Routing Rules

### Coding / Debugging
| Priority | Model | Fallback Condition |
|----------|-------|-------------------|
| 1st | `openai-codex/gpt-5.3-codex` | - |
| 2nd | `openai-codex/gpt-5.2-codex` | Primary < 20% |
| 3rd | `google-antigravity/gemini-3-pro-high` | All above < 20% |

### Complex Reasoning / Analysis
| Priority | Model | Fallback Condition |
|----------|-------|-------------------|
| 1st | `google-antigravity/claude-opus-4.6-thinking` | - |
| 2nd | `github-copilot/claude-4.6-opus` | Primary < 20% |
| 3rd | `github-copilot/claude-3.5-opus` | If 4.6 unavailable |
| 4th | `openai-codex/gpt-5.3` | All above < 20% |
| 5th | `openai-codex/gpt-5.2` | Last fallback |

## Fallback Threshold

Default: **20%** - Switches to fallback when primary drops below this.

## Cron Integration

This skill is designed to be called periodically via Cron for:
- Quota monitoring
- Reset detection (ping optimization)
- Automatic model switching recommendations
