---
name: ai-ppt-annual
description: AI年终总结PPT生成器。用户输入姓名、年份、工作成果亮点和下一年度规划，自动分类整理内容，生成结构完整、排版专业的年终总结PPT文件（.pptx格式），并通过飞书发送给用户。
metadata: { "openclaw": { "emoji": "📊", "requires": { "bins": ["node"] } } }
---

# AI-PPT Annual Summary Skill — AI年终总结PPT生成器

## 功能概述

引导用户输入年终总结所需信息，借助 AI 自动分类和润色内容，生成一份结构专业的 PPT 并发送给用户。

**PPT结构（共6-8页）：**
1. 封面页 — 姓名 + 年份 + 职位（可选）
2. 目录页
3. 年度工作总结（按类别分类展示）
4. 核心亮点与成果（数据化呈现）
5. 下一年度工作规划
6. 结语页

---

## 交互流程

### 阶段一：收集基本信息

当用户说「生成年终总结PPT」「年终汇报」「写年终总结」时触发。

**依次引导用户输入（可一次性提供，也可分步）：**

```
您好！我来帮您生成年终总结PPT 📊

请提供以下信息：
1. 您的姓名
2. 总结的年份（如：2025）
3. 职位/部门（可选，用于封面展示）
```

### 阶段二：收集工作内容

```
请输入您的工作成果和亮点（可以是流水账，我来帮您分类整理）：

示例格式：
- 主导了XX项目，完成了XX功能
- 招聘了X名工程师
- 主持了XX次培训/分享
- 推动XX指标提升了XX%
...

输入完成后，再告诉我下一年度的工作规划。
```

### 阶段三：AI分类整理

收到用户输入后，使用 AI 对工作内容进行智能分类，常见分类维度：

- **项目交付** — 主导/参与的重点项目
- **团队建设** — 人才招募、培训、组织建设
- **技术创新** — 技术攻关、工具创新、专利申请
- **流程优化** — 研发效率、工程体系建设
- **业务增长** — 业务指标、数据提升
- **对外影响** — 行业分享、合作拓展

> 根据用户实际输入内容，选取最匹配的3-5个分类，避免生成空分类。

### 阶段四：生成PPT

---

## PPT生成技术方案

使用 **pptxgenjs** Node.js 库生成 .pptx 文件。

### 环境准备

```bash
# 安装依赖（如未安装）
npm install pptxgenjs --prefix /tmp/pptx-pkg
```

### 设计规范

**配色方案（专业深蓝风格）：**
- 主色：`1A237E`（深蓝）
- 强调色：`42A5F5`（亮蓝）
- 背景：`F5F9FF`（浅蓝白）
- 文字主色：`FFFFFF`（白）/ `333333`（深灰）

**字体：** Microsoft YaHei（中文），Arial（英文/数字）

**布局：** LAYOUT_WIDE（16:9宽屏）

### 页面模板

#### 第1页：封面
- 深蓝背景 + 顶底装饰条
- 左侧竖线装饰
- 大标题：「{年份}年度工作汇报」
- 副标题：姓名 + 职位/部门
- 日期：生成当天日期

#### 第2页：目录
- 白色卡片列出各章节（自动根据分类生成）
- 带序号和章节描述

#### 第3页起：工作总结（每个分类一页或合并展示）
- 页头显示分类名称
- 内容以要点+说明形式展示
- 每页3-5个要点，超出自动换页

#### 倒数第2页：下一年度规划
- 深色背景
- 按规划主题分类展示（2-3个重点方向）

#### 最后一页：结语
- 「感谢聆听」居中大字
- 姓名 + 年份信息

### 代码执行方式

将生成脚本写入 `/tmp/gen_annual_ppt.mjs`，使用以下命令执行：

```bash
cd /tmp/pptx-pkg && node /tmp/gen_annual_ppt.mjs
```

输出文件路径：`/workspace/{姓名}_年度汇报_{年份}.pptx`

---

## 执行步骤（完整流程）

1. **收集信息** — 引导用户提供姓名、年份、工作内容、下一年规划
2. **AI分类** — 对工作内容进行智能分类整理，提炼核心亮点
3. **生成脚本** — 根据整理后的内容，编写完整的 pptxgenjs Node.js 脚本
4. **执行生成** — 使用 `exec` 工具运行脚本生成 .pptx 文件
5. **上传CDN** — 使用 `upload_to_cdn` 工具上传文件
6. **发送用户** — 通过飞书或当前 channel 将下载链接发送给用户

---

## 输出消息格式

```
🎉 您的年终总结PPT已生成！

📄 文件：{姓名}_年度汇报_{年份}.pptx
📑 共 {N} 页，包含：
  ✅ 封面 + 目录
  ✅ {分类1}（X项成果）
  ✅ {分类2}（X项成果）
  ...
  ✅ {年份+1}年工作规划
  ✅ 结语

📥 下载链接：{cdn_url}

如需调整内容或风格，告诉我即可 🎨
```

---

## 注意事项

- 工作内容分类由 AI 根据实际输入判断，不强制套模板
- 若用户输入较少，主动询问是否需要补充或直接生成简版
- 数字型成果（如"提升30%"、"招聘5人"）优先在「核心亮点」页突出展示
- PPT 风格默认为专业深蓝，用户可要求调整为其他风格（清新绿、商务灰等）
- 若 pptxgenjs 未安装，先执行安装命令再生成

## 触发关键词

- 「生成年终总结PPT」「年终汇报」「写年终总结」「做PPT」
- 「帮我做年终汇报」「生成工作总结PPT」
