# Nevada LLC — State Reference

## Governing Law
Nevada Revised Statutes (NRS) Chapter 86 — Limited-Liability Companies

## Key Differences from Nevada C-Corp
| Feature | Nevada LLC | Nevada C-Corp |
|---------|-----------|---------------|
| Formation document | Articles of Organization | Articles of Incorporation |
| Governance document | Operating Agreement | Bylaws |
| Owners called | Members | Shareholders |
| Management | Member-managed or Manager-managed | Board of Directors |
| Ownership units | Membership interests/units | Shares of stock |
| Taxation | Pass-through (default) | Double taxation (C-Corp) |
| Formalities | Minimal (no board meetings required) | More formal (board resolutions, minutes) |
| Profit distribution | Flexible (doesn't have to match ownership %) | Pro-rata to shares |

## Filing

### Where to File
- **Online:** [Nevada SilverFlume](https://www.nvsilverflume.gov/home)
- **Agency:** Nevada Secretary of State

### SilverFlume Instructions
1. Create account at nvsilverflume.gov
2. Select "New Entity Filing" → "Limited-Liability Company — Domestic"
3. For registered agent: select "entity," enter full RA name, pick exact match, verify "commercial"
4. Pay filing fee online
5. Save filed copy and note Entity Number

### Filing Fees
| Item | Cost | When |
|------|------|------|
| Articles of Organization | ~$75 | At filing |
| Initial List of Managers/Members + Business License | ~$350 | Within 30 days |
| Registered Agent (annual) | ~$100-150 | Annual |
| EIN | Free | After formation |
| **Total to form** | **~$525-575** | |

### Annual Requirements
| Item | Cost | When |
|------|------|------|
| Annual List of Managers/Members | ~$150 | Anniversary of formation |
| Business License Renewal | ~$200 | Anniversary of formation |
| Registered Agent | ~$100-150 | Annual |
| **Annual Total** | **~$450-500** | |

## Nevada LLC Advantages
- No state income tax (personal or corporate)
- No franchise tax
- Operating agreement not required to be filed (internal document)
- Charging order protection — creditors of individual members cannot seize LLC assets
- Flexible management structure
- Privacy — members/managers not listed in Articles (only in annual list)

## Operating Agreement
Nevada does not require an operating agreement, but you should always have one. It covers:
- Member ownership percentages and capital contributions
- Management structure (member-managed vs. manager-managed)
- Voting rights and decision-making procedures
- Profit and loss allocation
- Distribution rules
- Transfer restrictions
- Dissolution procedures
- Buy-sell provisions

**Key difference from Bylaws:** An operating agreement can allocate profits/losses differently from ownership percentages. A corporation cannot do this — dividends must be pro-rata per share class.

## Required Documents
1. **Articles of Organization** (filed with SOS)
2. **Operating Agreement** (internal — strongly recommended)
3. **Membership Ledger** (internal — tracks ownership)
4. **Filing Checklist** (internal)

### Articles of Organization Must Include (NRS 86.161):
- Company name (must include "Limited-Liability Company," "Limited Liability Company," "LLC," or "L.L.C.")
- Name and address of registered agent
- Name and address of at least one manager or managing member
- Name and address of the organizer

### Articles of Organization May Include:
- Purpose (defaults to "any lawful activity")
- Duration (defaults to perpetual)
- Management structure specification

## Post-Formation Deadlines
- **30 days:** File Initial List of Managers/Members + Business License at SilverFlume
- **Immediately after EIN:** Open bank account
- **If operating outside NV:** File for foreign qualification in operating state(s)

## Tax Treatment
- **Default:** Pass-through taxation (single member = disregarded entity / sole proprietorship; multi-member = partnership)
- **Election available:** Can elect to be taxed as S-Corp or C-Corp by filing IRS Form 8832 (entity classification) or Form 2553 (S-Corp)
- **Self-employment tax:** Members who are active in the business pay self-employment tax on their share of profits (unless S-Corp election)
