# Delaware LLC — State Reference

## Governing Law
Delaware Limited Liability Company Act (DLLCA), Title 6, Chapter 18 of the Delaware Code

## Why Delaware for an LLC?
- **Maximum flexibility** — operating agreement can override almost all default statutory rules
- **Strong asset protection** — robust charging order protections
- **Series LLC available** — can create separate "series" with segregated assets/liabilities within one LLC
- **Court of Chancery** — expert business court for disputes
- **Freedom of contract** — DLLCA is the most permissive LLC statute in the US

## Key Differences from Delaware C-Corp
| Feature | Delaware LLC | Delaware C-Corp |
|---------|-------------|-----------------|
| Formation document | Certificate of Formation | Certificate of Incorporation |
| Governance document | Operating Agreement (not filed) | Bylaws (not filed) |
| Owners called | Members | Shareholders |
| Taxation | Pass-through (default) | Double taxation |
| Franchise tax | $300/yr flat | $400+ (based on shares/assets) |
| Annual report | Not required | Required (with franchise tax) |
| Formalities | Minimal | More formal |
| Profit distribution | Flexible | Pro-rata to shares |

## Filing

### Where to File
- **Online:** [Delaware Division of Corporations](https://corp.delaware.gov) → File Online
- **Mail:** Division of Corporations, P.O. Box 898, Dover, DE 19903

### Filing Fees
| Item | Cost | When |
|------|------|------|
| Certificate of Formation | ~$90 | At filing |
| Certified copy (optional) | ~$50 | At filing |
| Registered Agent (annual) | ~$50-300 | Annual |
| EIN | Free | After formation |
| **Total to form** | **~$140-390** | |

### Annual Requirements
| Item | Cost | When |
|------|------|------|
| **Franchise Tax** | **$300 flat** | June 1 annually |
| Registered Agent | ~$50-300 | Annual |
| **Annual Total** | **~$350-600** | |

**Note:** Delaware LLC franchise tax is a flat $300 — much simpler than the C-Corp calculation. Due June 1 (not March 1 like corps).

## Certificate of Formation
Extremely simple — Delaware's Certificate of Formation is one of the shortest formation documents in the US:

### Must Include (DLLCA §18-201):
- LLC name (must include "Limited Liability Company" or "LLC" or "L.L.C.")
- Name and address of registered agent in Delaware

That's it. Everything else goes in the Operating Agreement.

### May Include:
- Any other matters the members decide to include
- Effective date (if different from filing date)

## Operating Agreement
- **Not filed** with the state
- **Not required** by Delaware law, but essential in practice
- **Governs everything** — management, economics, voting, transfers, dissolution
- **Maximum flexibility** — can override almost all DLLCA default rules
- **Oral agreements are valid** under Delaware law (but never do this)

### Operating Agreement Should Cover:
- Member names, ownership percentages, capital contributions
- Management structure (member-managed or manager-managed)
- Voting rights and procedures
- Profit/loss allocation and distribution rules
- Transfer restrictions and right of first refusal
- Admission of new members
- Withdrawal/resignation procedures
- Dissolution triggers and procedures
- Non-compete and non-solicitation provisions
- Tax elections and reporting
- Indemnification

## Required Documents
1. **Certificate of Formation** (filed with Division of Corporations)
2. **Operating Agreement** (internal — strongly recommended)
3. **Membership Ledger** (internal — tracks ownership)
4. **Filing Checklist** (internal)

## Post-Formation Deadlines
- **June 1 annually:** Franchise tax ($300) due
- **Immediately after EIN:** Open bank account
- **If operating outside DE:** File for foreign qualification in operating state(s)

## Recommended Registered Agents (Delaware)
- **Harvard Business Services** — $50/yr (Delaware specialist)
- **Northwest Registered Agent** — $125/yr
- **Registered Agent Solutions** — $49/yr

## Series LLC (Unique to Delaware)
Delaware allows "Series LLCs" — a single LLC that contains multiple series, each with:
- Separate assets and liabilities
- Separate members/managers
- Separate business purposes

**Use case:** Real estate (separate series per property), investment funds, multi-brand businesses.
Requires specific language in Certificate of Formation and Operating Agreement.
