# Delaware C-Corp — State Reference

## Governing Law
Delaware General Corporation Law (DGCL), Title 8 of the Delaware Code

## Why Delaware?
- **#1 state for incorporation** — 68% of Fortune 500, most VC-backed startups
- **Court of Chancery** — dedicated business court (no juries), extensive case law, fast resolutions
- **Investor-friendly** — standard VC financing docs (SAFEs, Series A) are designed for Delaware corps
- **Director protections** — strong business judgment rule, exculpation allowed (DGCL §102(b)(7))
- **Flexible corporate law** — broad freedom in structuring governance

## Filing

### Where to File
- **Online:** [Delaware Division of Corporations](https://corp.delaware.gov) → File Online
- **Mail:** Division of Corporations, P.O. Box 898, Dover, DE 19903
- **Agency:** Delaware Division of Corporations (under Secretary of State)

### Key Differences from Nevada
| Feature | Delaware | Nevada |
|---------|----------|--------|
| Filing document | Certificate of Incorporation | Articles of Incorporation |
| Filing website | corp.delaware.gov | nvsilverflume.gov |
| Franchise tax | Yes ($400 min/yr) | No franchise tax |
| State income tax | No (if not operating in DE) | No |
| Initial officers list | Not required to file | Required within 30 days |
| Business license | Not required | Required (~$200/yr) |
| Court system | Court of Chancery (expert) | District courts (general) |
| Annual report | Annual franchise tax report (Mar 1) | Annual List (anniversary date) |

### Filing Fees
| Item | Cost | When |
|------|------|------|
| Certificate of Incorporation | ~$89 (1 page) + $9/additional page | At filing |
| Registered Agent (annual) | ~$100-300 | Annual |
| EIN | Free | After incorporation |
| **Total to incorporate** | **~$189-389** | |

### Annual Requirements (CRITICAL — more expensive than Nevada)
| Item | Cost | When |
|------|------|------|
| **Franchise Tax** | **$400 minimum** (Authorized Shares Method or Assumed Par Value Method) | March 1 annually |
| Annual Report | Included with franchise tax | March 1 annually |
| Registered Agent | ~$100-300 | Annual |
| **Annual Total** | **~$500-700 minimum** | |

**⚠️ Franchise Tax Warning:** Delaware's franchise tax can be **very high** if calculated wrong. The default "Authorized Shares Method" charges based on authorized shares:
- 5,000 shares or less: $400
- 5,001-10,000 shares: $400 + $85/5,000 shares
- 10M authorized shares: **$170,165** under this method!

**Always use the "Assumed Par Value Capital Method"** — it calculates based on total gross assets and issued shares. For most startups with low-par-value stock and minimal assets, this brings it down to the **$400 minimum**.

File your franchise tax report at: https://corp.delaware.gov/paytaxes/

## Stock Rules
- **Consideration:** Cash, services, personal property, real estate, leases, or any combination (DGCL §152)
- **Par value:** Any amount, including no par value
- **No minimum capital** required
- **Treasury shares:** Allowed (DGCL §160)
- **Blank check preferred:** Board can create series of preferred without shareholder vote (DGCL §102(a)(4)) — standard for VC financing

## Required Documents
1. **Certificate of Incorporation** (filed with Division of Corporations) — this is the Delaware equivalent of Articles of Incorporation
2. **Bylaws** (internal, not filed)
3. **Action of Incorporator** (internal)
4. **Organizational Resolutions / Written Consent of Directors** (internal)
5. **Stock Ledger** (internal, must be maintained per DGCL §219)

### Certificate of Incorporation Must Include (DGCL §102):
- Company name (must include "Corporation," "Incorporated," "Company," "Association," or abbreviation)
- Registered agent name and address in Delaware
- Corporate purpose (can be general "any lawful activity")
- Authorized shares (number, par value, classes)
- Incorporator name and address

### Certificate of Incorporation May Include:
- Exculpation clause (limits director personal liability — DGCL §102(b)(7))
- Forum selection clause (requires disputes in Delaware courts)
- Board power provisions
- Blank check preferred authorization

## Post-Incorporation Deadlines
- **No initial officers list** required (unlike Nevada)
- **March 1 annually:** Franchise tax + annual report due
- **If operating outside DE:** File for foreign qualification in operating state(s)

## Foreign Qualification
Most Delaware corps don't operate in Delaware — they incorporate there for legal advantages. You will almost certainly need to foreign-qualify in your operating state (e.g., Texas, California, Florida), which means:
- Additional registered agent in that state
- Foreign qualification filing in that state
- Additional annual fees and state taxes in that state
- Potentially state income tax in operating state

## Recommended Registered Agents (Delaware)
- **Northwest Registered Agent** — $125/yr
- **Harvard Business Services** — $50/yr (Delaware-focused, popular for DE corps)
- **Registered Agent Solutions** — $49/yr
- **Corporation Service Company (CSC)** — $299/yr (enterprise-grade)
