import os
import sys
import requests
import json


def ai_picture_book_task_create(api_key: str, method: int, content):
    url = "https://qianfan.baidubce.com/v2/tools/ai_picture_book/task_create"
    headers = {
        "Authorization": "Bearer %s" % api_key,
        "X-Appbuilder-From": "openclaw",
        "Content-Type": "application/json"
    }
    params = {
        "method": method,
        "input_type": "1",
        "input_content": content,
    }
    response = requests.post(url, headers=headers, json=params)
    response.raise_for_status()
    result = response.json()
    if "code" in result:
        raise RuntimeError(result["detail"])
    if "errno" in result and result["errno"] != 0:
        raise RuntimeError(result["errmsg"])
    return result["data"]


if __name__ == "__main__":
    if len(sys.argv) < 3:
        print("Usage: python ai_picture_book_task_create.py <method> <content>")
        sys.exit(1)

    method = int(sys.argv[1])
    if method not in [9, 10]:
        print("Error: method must be 9 or 10.")
        sys.exit(1)
    content = sys.argv[2]

    api_key = os.getenv("BAIDU_API_KEY")
    if not api_key:
        print("Error: BAIDU_API_KEY must be set in environment.")
        sys.exit(1)
    try:
        results = ai_picture_book_task_create(api_key, method, content)
        print(json.dumps(results, ensure_ascii=False, indent=2))
    except Exception as e:
        print(f"Error: {str(e)}")
        sys.exit(1)
