# 📣 Marketing Assistant Starter Pack

A pre-configured AI Persona setup for content creation and brand growth.

---

## What's Included

| File | Purpose |
|------|---------|
| `SOUL.md` | Spark — an energetic, brand-aware marketing assistant |
| `HEARTBEAT.md` | Daily ops with performance tracking, engagement, content calendar |

---

## How to Use

1. Copy these files to your workspace
2. Customize for your brand:
   - Update brand voice and guidelines
   - Configure platform-specific settings
   - Set up content pillars
   - Add performance benchmarks
3. Run the setup wizard for remaining files

---

## This Pack is For You If:

- You manage social media or content marketing
- You need help with content creation
- You want to track engagement and performance
- You're building a personal or company brand
- Consistency and brand voice matter

---

## Key Features

### 📊 Performance Tracking
- Daily engagement metrics
- Comparison to benchmarks
- Trend identification
- Content performance analysis

### 📝 Content Management
- Content calendar overview
- Pipeline visibility
- Platform-specific formatting
- Content pillar balance

### 💬 Engagement Management
- Comment response tracking
- DM monitoring
- Mention acknowledgment
- Sentiment awareness

### 🔥 Trend Monitoring
- Relevant trending topics
- Opportunity assessment
- Competitor activity
- Industry news

---

## Customize These:

### In SOUL.md:
- [ ] Change "Morgan" to your name
- [ ] Update brand voice attributes
- [ ] Configure platform preferences
- [ ] Set content pillars for your brand
- [ ] Add your writing style examples

### In HEARTBEAT.md:
- [ ] Set your engagement benchmarks
- [ ] Configure content calendar structure
- [ ] Add your platforms and metrics
- [ ] Set response time goals

---

## Example Daily Briefing

```
MARKETING BRIEFING — Monday, January 27, 2026

📊 YESTERDAY'S PERFORMANCE
- Top post: LinkedIn carousel — 5.2% engagement (+2.1%)
- Total engagement: 847 interactions
- New followers: +43 across platforms

🔥 TRENDING NOW
- "AI productivity" trending on LinkedIn — HIGH relevance
- Opportunity: Quick take on our AI workflow?

📅 TODAY'S CONTENT
- LinkedIn: "5 automation mistakes" carousel — READY
- Twitter: Thread on delegation — NEEDS REVIEW
- Instagram: Behind-the-scenes story — SCHEDULED

💬 ENGAGEMENT NEEDED
- 12 comments to respond to (2 high-priority)
- 3 DMs pending
- 5 mentions to acknowledge

⚠️ WATCH
- Competitor launched new campaign yesterday
- Consider response content?

🎯 PRIORITIES
1. Respond to high-priority comments
2. Finalize Twitter thread for approval
3. Draft response to competitor campaign

HEARTBEAT_OK
```

---

## Writing Style Quick Reference

**Hook formulas:**
- "Most people get [X] wrong..."
- "I spent [time] learning [X]. Here's what I wish I knew..."
- "Stop doing [common mistake]."
- "[Contrarian opinion]."

**Structure:**
```
Hook (stop the scroll)
↓
Context (why this matters)
↓
Value (the insight/lesson)
↓
Proof (example/story)
↓
CTA (what to do next)
```

---

*Part of AI Persona OS by Jeff J Hunter — https://os.aipersonamethod.com*
