# 🖥️ Coding Assistant Starter Pack

A pre-configured AI Persona setup for software development.

---

## What's Included

| File | Purpose |
|------|---------|
| `SOUL.md` | Axiom — a direct, technical coding assistant |
| `HEARTBEAT.md` | Daily ops with CI/CD checks, PR reviews, build status |
| `KNOWLEDGE.md` | Tech stack reference, code patterns, common issues |

---

## How to Use

1. Copy these files to your workspace
2. Customize for your specific stack:
   - Update languages/frameworks in KNOWLEDGE.md
   - Add your repo's patterns and conventions
   - Configure your CI/CD and deployment info
3. Run the setup wizard for the remaining files (USER.md, MEMORY.md, etc.)

---

## This Pack is For You If:

- You're a developer or have a dev team
- You want help with coding, debugging, and code review
- You use Git-based workflows
- You have CI/CD pipelines to monitor

---

## Customize These:

### In SOUL.md:
- [ ] Change "Alex" to your name
- [ ] Update technical preferences
- [ ] Adjust communication style

### In HEARTBEAT.md:
- [ ] Add your actual repos and PR links
- [ ] Configure your CI/CD commands
- [ ] Set up your monitoring alerts

### In KNOWLEDGE.md:
- [ ] Replace tech stack with yours
- [ ] Add your codebase patterns
- [ ] Document your deployment process
- [ ] Add environment variables

---

## Example HEARTBEAT Output

```
HEARTBEAT — Monday, January 27, 2026, 9:15 AM PST
📚 Context: 12k/200k (6%)
⚙️ Status: Operational

✅ Step 1: Context
Loaded yesterday's session. Last worked on auth refactor.

✅ Step 2: System Status
- Dev environment: 🟢
- Git: 🟢 Clean working tree
- Tests: 🟢 All passing

✅ Step 3: Priority Scan
- PRs: 2 open, 1 needs review
- CI: All builds passing
- Alerts: None

✅ Step 4: Assessment
- No blockers
- Continue auth refactor
- PR #142 needs review by EOD

HEARTBEAT_OK
Focus: Complete auth refactor, review PR #142
```

---

*Part of AI Persona OS by Jeff J Hunter — https://os.aipersonamethod.com*
