# Checkpoint Templates

> Use these formats based on context usage level.

---

## Full Checkpoint (70-84% context)

```markdown
## Context Checkpoint — [HH:MM]

### Current Session
**Started:** [time/date]
**Task:** [what we're working on]
**Status:** in progress / blocked / completing

### Work State

**Active Files:**
- [file1.ext] — [what we're doing with it]
- [file2.ext] — [status]

**Key Decisions Made:**
- [Decision 1]: [reasoning]
- [Decision 2]: [reasoning]

**Progress:**
- [x] [Completed step]
- [x] [Completed step]
- [ ] [In progress] ← WE ARE HERE
- [ ] [Next step]
- [ ] [Future step]

### Context to Preserve

**Human's Goals:**
[What they're ultimately trying to achieve]

**Important Constraints:**
[Things we must not forget]

**Preferences Expressed:**
[How they want things done]

### Resume Instructions
1. [First thing to do]
2. [Second thing to do]
3. [Continue from step X]

### Open Questions
- [Unresolved item]
```

---

## Emergency Checkpoint (85%+ context)

```markdown
## EMERGENCY CHECKPOINT — [HH:MM]

**TASK:** [one line]
**STATUS:** [one line]
**NEXT:** [one line]
**BLOCKED:** [if applicable]
**FILES:** [list]
```

---

## Pre-Operation Checkpoint

Use before any operation that could fail or take significant time.

```markdown
## Pre-Operation — [HH:MM]

**About to:** [operation]
**Current state:** [where we are]
**After success:** [what to do next]
**If failure:** [recovery steps]
```

---

## Quick Notes (50-69% context)

```markdown
### [HH:MM] Note
[Brief context worth preserving]
```

---

## Threshold Reference

| Usage | Action |
|-------|--------|
| < 50% | Normal operation |
| 50-69% | Quick notes in daily log |
| 70-84% | **Full checkpoint NOW** |
| 85-94% | Emergency checkpoint |
| 95%+ | Survival data only |

---

## Recovery Steps

After context loss:

1. Check `memory/[TODAY].md` for latest checkpoint
2. Check `memory/checkpoint-latest.md`
3. Read MEMORY.md for background
4. Follow resume instructions
5. Tell human: "Resuming from checkpoint at [time]..."

---

*The best checkpoint is the one you write before you need it.*

---

*Part of AI Persona OS by Jeff J Hunter — https://os.aipersonamethod.com*
