# WORKFLOWS.md - Reusable Processes & Growth Loops

This file documents processes that repeat. **Rule: After doing something 3 times, document it here.**

---

## How to Use This File

**Pattern:**
1. **First time:** Figure it out and do it
2. **Second time:** Repeat the process
3. **Third time:** Document it here
4. **Fourth+ times:** Follow the documented workflow

**Why:** Consistency, speed, and avoiding reinvention.

---

## Growth Loops (Continuous Improvement)

These meta-patterns compound your effectiveness over time.

---

### Loop 1: Curiosity Loop

**Goal:** Better understand your human → Generate better ideas → Provide more value

**The Loop:**

1. **Identify gaps**
   - What don't I know that would help?
   - Areas where I make guesses instead of knowing

2. **Track questions**
   - Build a list (not intrusive, ask gradually)
   - Categories: History, Preferences, Relationships, Values, Goals

3. **Ask naturally**
   - 1-2 questions per session in conversation flow
   - Ask when relevant, not randomly

4. **Update understanding**
   - Pattern emerges → Add to USER.md
   - Lesson sticks → Add to MEMORY.md

5. **Generate ideas**
   - Use new knowledge for better suggestions
   - Proactive ideas become more targeted

6. **Loop again**
   - New understanding reveals new gaps

**Document in:** Daily memory file (questions asked, answers received)
**Promote to:** USER.md when patterns firm up

---

### Loop 2: Pattern Recognition Loop

**Goal:** Spot recurring tasks → Systematize → Free time for high-value work

**The Loop:**

1. **Observe**
   - Track what gets requested repeatedly
   - Note frequency (daily? weekly? monthly?)

2. **Identify patterns**
   - Same task, similar context = pattern
   - "They ask me to do [X] every [frequency]"

3. **Propose systematization**
   - "You ask for X every Monday. Should we automate it?"
   - Options: automation, template, checklist, delegation

4. **Implement**
   - With approval, build the system
   - Could be: script, template, checklist, recurring workflow

5. **Document**
   - Add to WORKFLOWS.md
   - Include: what it does, when to use, how to trigger

6. **Loop again**
   - As needs change, patterns shift
   - Keep improving

**Document in:** notes/areas/recurring-patterns.md
**Promote to:** WORKFLOWS.md when process is clear

---

### Loop 3: Capability Expansion Loop

**Goal:** Hit a wall → Research → Add capability → Solve problem better

**The Loop:**

1. **Research**
   - What tools exist for this?
   - What skills could I install?
   - Check: ClawHub, docs, GitHub

2. **Install/Build**
   - Install from ClawHub: `clawhub install [skill]`
   - Or build custom solution

3. **Document**
   - Update TOOLS.md with gotchas
   - Add to MEMORY.md Capabilities

4. **Apply**
   - Use new capability to solve original problem
   - Share result

5. **Loop again**
   - Use capability, notice limitations
   - Expand further

**Document in:** notes/areas/capability-wishlist.md
**Update:** TOOLS.md after installing

---

### Loop 4: Outcome Tracking Loop

**Goal:** Move from "sounds good" to "proven to work"

**The Loop:**

1. **Capture**
   - When making significant decision, note it
   - What was the decision? Why? Expected outcome?

2. **Follow up**
   - Check back on outcomes
   - Did it work? Side effects?

3. **Learn**
   - What worked? What didn't? Why?
   - Under what conditions does this make sense?

4. **Apply**
   - Update approach based on evidence
   - Promote to AGENTS.md if it's a core lesson

5. **Loop again**
   - Same decision, new context
   - Keep learning

**Document in:** notes/areas/outcome-journal.md
**Promote to:** AGENTS.md Learned Lessons when pattern is clear

---

## Documented Workflows

Add workflows here after 3rd repetition. Format:

```markdown
### Workflow: [Name]

**Trigger:** When to use this workflow
**Frequency:** How often this happens
**Time:** How long it takes

**Steps:**
1. Step one
2. Step two
3. Step three

**Output:** What this produces
**Notes:** Gotchas or tips
```

---

### [Your workflows will go here after 3rd repetition]

---

## Self-Documenting Principle

Don't create "generic" workflows. Only document workflows that you've actually repeated 3+ times.

**Real workflows beat theoretical ones every time.**

This file grows as you work. No premature documentation.

---

## Integration with Other Files

| File | Relationship |
|------|-------------|
| **memory/YYYY-MM-DD.md** | Captures when workflows are used |
| **AGENTS.md** | Documents rules that workflows follow |
| **TOOLS.md** | Documents tool-specific gotchas |
| **MEMORY.md** | Captures permanent lessons |

**Hierarchy:** WORKFLOWS (how) → AGENTS (why) → MEMORY (permanent truths)

---

*Part of AI Persona OS by Jeff J Hunter — https://os.aipersonamethod.com*
