# TOOLS.md — Tool Reference & Gotchas

**Purpose:** Document tools you use and their quirks. Save future-you hours of rediscovery.

---

## How to Use This File

When you learn something about a tool that isn't obvious:
1. Add it here immediately
2. Include the gotcha, workaround, and example
3. Reference this file before using tools

---

## Tool Template

```markdown
### [Tool Name]

**What it does:** [Brief description]
**Documentation:** [Link]

**Setup:**
- [Step 1]
- [Step 2]

**Common Commands:**
| Command | What It Does |
|---------|--------------|
| `command` | Description |

**Gotchas:**
- ⚠️ [Thing that's not obvious]
- ⚠️ [Common mistake to avoid]

**Examples:**
\`\`\`bash
# Example usage
command --flag value
\`\`\`
```

---

## Installed Tools

[Add your tools below as you learn their quirks]

---

### Example: Discord Bot

**What it does:** Send/read messages in Discord servers
**Documentation:** [Your bot docs]

**Common Commands:**
| Command | What It Does |
|---------|--------------|
| `message action=read channel=discord channelId=ID limit=15` | Read recent messages |
| `message action=send channel=discord channelId=ID content="text"` | Send message |

**Gotchas:**
- ⚠️ Use channel IDs, not names (names can change)
- ⚠️ Bot must have permissions in the channel
- ⚠️ "Missing Access" usually means permission issue, not bot offline
- ⚠️ Rate limits: Don't spam reads/sends

**Troubleshooting:**
| Error | Cause | Fix |
|-------|-------|-----|
| Missing Access | No permission | Check bot role in server settings |
| Unknown Channel | Wrong ID | Verify channel ID in Discord |
| Rate Limited | Too many requests | Wait and retry |

---

### Example: Google Calendar

**What it does:** Read/write calendar events
**Documentation:** [Link]

**Common Commands:**
| Command | What It Does |
|---------|--------------|
| `gog calendar list --account email` | List today's events |
| `gog calendar create --account email --title "Meeting"` | Create event |

**Gotchas:**
- ⚠️ Always specify `--account` flag
- ⚠️ Times are in account's timezone unless specified
- ⚠️ OAuth token expires — may need to re-auth

---

## API Keys & Credentials

**DO NOT store actual credentials here.**

| Service | Location | Notes |
|---------|----------|-------|
| [Service] | Environment variable: `VAR_NAME` | [Notes] |
| [Service] | Secrets manager path | [Notes] |

---

## Tool Wishlist

Tools you want but don't have yet:

- [ ] [Tool name] — [What it would help with]
- [ ] [Tool name] — [What it would help with]

---

*Update this file whenever you learn something about a tool.*

---

*Part of AI Persona OS by Jeff J Hunter — https://os.aipersonamethod.com*
