# TEAM.md — Team Roster & Platform Configuration

**Purpose:** Help your AI Persona know who's who, how to reach them, and channel priorities.

---

## Team Roster

| Name | Role | Platforms | Notes |
|------|------|-----------|-------|
| [Name] | [Role/Title] | Discord: `<@ID>` | [Key responsibilities] |
| [Name] | [Role/Title] | Slack: `<@ID>` | [Key responsibilities] |
| [Name] | [Role/Title] | Email: address | [Key responsibilities] |

### Template for Each Member

```markdown
### [Name]
- **Role:** [Title/Function]
- **Reports to:** [Who]
- **Responsible for:** [Key areas]
- **Contact for:** [When to reach out to them]
- **Platforms:**
  - Discord: `<@USER_ID>`
  - Slack: `<@SLACK_ID>`
  - Email: [address]
- **Aliases:** [Nicknames, shortened names]
- **Notes:** [Working hours, preferences, etc.]
```

---

## Platform Configuration

### Discord

**Servers:**
| Server Name | Guild ID | Purpose | Confidentiality |
|-------------|----------|---------|-----------------|
| [Server 1] | [ID] | [Purpose] | Public / Internal / Confidential |
| [Server 2] | [ID] | [Purpose] | Public / Internal / Confidential |

**Priority Channels:**

#### P1 — Critical (Check First)
| Channel | ID | What to Look For |
|---------|----| -----------------|
| #[channel] | [ID] | [What makes this critical] |

#### P2 — Important
| Channel | ID | What to Look For |
|---------|----| -----------------|
| #[channel] | [ID] | [What to monitor] |

#### P3 — Monitor
| Channel | ID | What to Look For |
|---------|----| -----------------|
| #[channel] | [ID] | [Background monitoring] |

#### P4 — Background
| Channel | ID | What to Look For |
|---------|----| -----------------|
| #[channel] | [ID] | [Low priority] |

**Discord Commands:**
```bash
# Read messages from a channel
message action=read channel=discord channelId=[ID] limit=15

# Send message to channel
message action=send channel=discord channelId=[ID] content="[message]"

# Mention a user
<@USER_ID>
```

---

### Slack

**Workspaces:**
| Workspace | ID | Purpose |
|-----------|----| --------|
| [Workspace] | [ID] | [Purpose] |

**Priority Channels:**
| Channel | What to Look For |
|---------|------------------|
| #[channel] | [What makes this important] |

**Slack Commands:**
```bash
# Mention format
<@SLACK_USER_ID>
```

---

### Email

**Monitored Inboxes:**
| Email | Purpose | Check Frequency |
|-------|---------|-----------------|
| [address] | [Purpose] | [How often] |

---

## Confidentiality Levels

| Level | Who Can See | What Can Be Shared |
|-------|-------------|-------------------|
| **Public** | Anyone | General information, public updates |
| **Internal** | Team only | Work discussions, project details |
| **Confidential** | Named individuals only | Strategy, HR, sensitive business |

### Confidentiality Rules

- **Public channels:** Safe to reference anywhere
- **Internal channels:** Don't share outside team
- **Confidential channels:** Only discuss with [HUMAN] and explicitly named people

---

## How to Mention Team Members

**Discord:** `<@USER_ID>` — Always use IDs, not names (ensures notification)

**Slack:** `<@SLACK_ID>` — Use member ID

**Email:** Use full email address

**In conversation:** Check this file for correct IDs before mentioning

---

## Finding the Right Person

| For questions about... | Contact |
|-----------------------|---------|
| [Area 1] | [Name] |
| [Area 2] | [Name] |
| [Area 3] | [Name] |
| Everything else | [HUMAN] |

---

## Team Communication Norms

- **Response expectations:** [How quickly should messages be answered]
- **Escalation path:** [Who to go to if someone is unavailable]
- **Meeting notes:** [Where they're stored, who takes them]
- **Announcements:** [Which channel, who can post]

---

*Keep this file updated as team members change.*

---

*Part of AI Persona OS by Jeff J Hunter — https://os.aipersonamethod.com*
