# INDEX.md — File Organization Reference

**Purpose:** Know where everything lives. One source of truth for file locations.

---

## Core Files

| File | Purpose | Update Frequency |
|------|---------|------------------|
| `SOUL.md` | Who the AI Persona is | Rarely (personality is stable) |
| `USER.md` | Who you are | When context changes |
| `TEAM.md` | Team roster & platforms | When team changes |
| `SECURITY.md` | Security rules | Monthly review |
| `MEMORY.md` | Permanent facts | When you learn something permanent |
| `AGENTS.md` | Operating rules | When lessons are learned |
| `HEARTBEAT.md` | Daily checklist | When priorities change |
| `WORKFLOWS.md` | Reusable processes | After 3rd repetition of a task |
| `TOOLS.md` | Tool gotchas | When you learn tool quirks |
| `INDEX.md` | This file | When organization changes |
| `KNOWLEDGE.md` | Domain expertise | When expertise expands |

---

## Directories

```
workspace/
├── memory/              → Session logs and checkpoints
│   ├── YYYY-MM-DD.md   → Daily session files
│   └── archive/        → Old logs (90+ days)
│
├── .learnings/          → Learning capture (before promotion)
│   ├── LEARNINGS.md    → Insights and corrections
│   └── ERRORS.md       → Failures and fixes
│
├── projects/            → Work output organized by project
│   └── [project-name]/ → Individual project folders
│
├── notes/               → Miscellaneous notes
│   └── areas/          → Topic-specific notes
│       ├── proactive-ideas.md
│       ├── recurring-patterns.md
│       └── capability-wishlist.md
│
└── backups/             → Checkpoint and file backups
```

---

## File Naming Convention

**Format:** `Description_Context_MMDDYY.ext`

**Examples:**
- `Meeting_Notes_ClientA_012726.md`
- `Logo_Draft_ProjectX_012726.png`
- `Report_Q1_Analysis_012726.pdf`

**Rules:**
- Use underscores for separation
- Include date for versioning
- Be descriptive but concise
- Keep related files together

---

## Memory Files

| Pattern | Purpose |
|---------|---------|
| `memory/YYYY-MM-DD.md` | Daily session log |
| `memory/archive/*.md` | Historical logs |

**Daily file contains:**
- Session notes
- Checkpoints
- Decisions made
- Action items

---

## Finding Things

### "Where's the info about...?"

| Topic | Location |
|-------|----------|
| AI Persona personality | SOUL.md |
| Human preferences | USER.md |
| Team contacts | TEAM.md |
| What happened yesterday | memory/[yesterday].md |
| Permanent facts | MEMORY.md |
| How to do X | WORKFLOWS.md |
| Tool commands | TOOLS.md |
| Security rules | SECURITY.md |
| Recent learnings | .learnings/LEARNINGS.md |
| Recent errors | .learnings/ERRORS.md |

### "Where should I put...?"

| Content Type | Location |
|--------------|----------|
| Session notes | memory/YYYY-MM-DD.md |
| Permanent fact | MEMORY.md |
| New process (3x used) | WORKFLOWS.md |
| Tool gotcha | TOOLS.md |
| Lesson learned | .learnings/LEARNINGS.md → promote to AGENTS.md |
| Error and fix | .learnings/ERRORS.md |
| Project work | projects/[project-name]/ |
| Proactive idea | notes/areas/proactive-ideas.md |

---

## Quick Access

**Start of session:** 
1. SOUL.md → SECURITY.md → USER.md → memory/[today].md

**During work:**
- Check WORKFLOWS.md before starting tasks
- Write to memory/[today].md as you go
- Reference TOOLS.md for commands

**End of session:**
- Write checkpoint to memory/[today].md
- Promote any learnings
- Note tomorrow's priorities

---

*Update this file when you change how things are organized.*

---

*Part of AI Persona OS by Jeff J Hunter — https://os.aipersonamethod.com*
