# Errors

> Command and operation failures. Track to identify patterns.

---

## Entry Format

```markdown
## [ERR-YYYYMMDD-XXX] [category]

**Logged:** YYYY-MM-DD HH:MM
**Priority:** low | medium | high | critical
**Status:** pending | in_progress | resolved | promoted | wont_fix
**Area:** tool | api | permission | config | network | other

### Summary
One-line description of the error

### Error Output
```
[Paste actual error message]
```

### Context
What were you trying to do?

### Root Cause
[After investigation]

### Resolution
[How it was fixed]
```

---

## Active Errors

<!-- Add new errors here -->

---

## Patterns

> Recurring error types and standard fixes

### Permission Errors
- Check file/directory permissions
- Verify user context
- Check ACLs

### API Errors
- Verify credentials
- Check rate limits
- Validate request format

### Network Errors
- Check connectivity
- Verify DNS
- Check firewall/proxy

### Timeout Errors
- Check target availability
- Adjust timeout values
- Check for resource overload

---

## Resolved

<!-- Move fixed errors here for reference -->

---

*Every error is a chance to build resilience.*

---

*Part of AI Persona OS by Jeff J Hunter — https://os.aipersonamethod.com*
