---
name: ai-notes-ofvideo
description: Generate AI-powered notes from videos (document, outline, or graphic-text formats)
metadata: { "openclaw": { "emoji": "📺", "requires": { "bins": ["python3"], "env":["BAIDU_API_KEY"]},"primaryEnv":"BAIDU_API_KEY" } }
---

# AI Video Notes

Generate structured notes from video URLs using Baidu AI. Supports three note formats.

## Workflow

1. **Create Task**: Submit video URL → get task ID
2. **Poll Status**: Query task every 3-5 seconds until completion
3. **Get Results**: Retrieve generated notes when status = 10002

## Status Codes

| Code | Status | Action |
|-------|---------|---------|
| 10000 | In Progress | Continue polling |
| 10002 | Completed | Return results |
| Other | Failed | Show error |

## Note Types

| Type | Description |
|------|-------------|
| 1 | Document notes |
| 2 | Outline notes |
| 3 | Graphic-text notes |

## APIs

### Create Task

**Endpoint**: `POST /v2/tools/ai_note/task_create`

**Parameters**:
- `video_url` (required): Public video URL

**Example**:
```bash
python3 scripts/ai_notes_task_create.py 'https://example.com/video.mp4'
```

**Response**:
```json
{
  "task_id": "uuid-string"
}
```

### Query Task

**Endpoint**: `GET /v2/tools/ai_note/query`

**Parameters**:
- `task_id` (required): Task ID from create endpoint

**Example**:
```bash
python3 scripts/ai_notes_task_query.py "task-id-here"
```

**Response** (Completed):
```json
{
  "status": 10002,
  "notes": [
    {
      "tpl_no": "1",
      "contents: ["Note content..."]
    }
  ]
}
```

## Polling Strategy

### Option 1: Manual Polling
1. Create task → store `task_id`
2. Query every 3-5 seconds:
   ```bash
   python3 scripts/ai_notes_task_query.py <task_id>
   ```
3. Show progress updates:
   - Status 10000: Processing...
   - Status 10002: Completed
4. Stop after 30-60 seconds (video length dependent)

### Option 2: Auto Polling (Recommended)
Use the polling script for automatic status updates:

```bash
python3 scripts/ai_notes_poll.py <task_id> [max_attempts] [interval_seconds]
```

**Examples**:
```bash
# Default: 20 attempts, 3-second intervals
python3 scripts/ai_notes_poll.py "task-id-here"

# Custom: 30 attempts, 5-second intervals
python3 scripts/ai_notes_poll.py "task-id-here" 30 5
```

**Output**:
- Shows real-time progress: `[1/20] Processing... 25%`
- Auto-stops when complete
- Returns formatted notes with type labels

## Error Handling

- Invalid URL: "Video URL not accessible"
- Processing error: "Failed to parse video"
- Timeout: "Video too long, try again later"
