---
name: ai-news-zh
description: 中文AI科技日报自动采集与推送。从The Verge、Wired、TechCrunch等英文源抓取最新AI资讯，自动翻译整理为中文，按分类推送到飞书/Telegram/Discord等渠道。适合关注AI行业动态的中文用户。
metadata:
  openclaw:
    requires:
      tools: [web_fetch]
    optional:
      tools: [web_search, message]
---

# AI News ZH - 中文AI科技日报

自动从多个英文科技媒体采集AI相关新闻，翻译整理为中文日报并推送。

## 功能
- 从 The Verge AI、Wired AI、TechCrunch 等源自动采集
- 智能筛选AI相关内容
- 自动翻译为中文并分类（大模型/Agent/融资/安全/应用/开源）
- 支持定时推送到飞书、Telegram、Discord等渠道
- 去重和增量更新

## 使用方式

### 手动触发
告诉你的AI助手：
> 帮我采集今天的AI新闻，整理成中文日报

### 定时推送（推荐）
设置cron任务，每天早上自动推送：
```
你是AI新闻助手。请按照 ai-news-zh 技能的流程，采集最新AI资讯并推送中文日报。
```

## 数据源

| 源 | 类型 | 说明 |
|---|---|---|
| The Verge AI | 网页 | 综合AI报道，覆盖面广 |
| Wired AI | RSS | 深度报道，独家视角 |
| TechCrunch | RSS | 创投+AI动态，融资消息多 |
| Anthropic News | 网页 | 官方动态 |
| MIT Tech Review | RSS | 深度科技报道 |

## 分类体系

- 🧠 大模型 — 新模型发布、基准测试、技术突破
- 🤖 Agent — AI代理、自动化、工具使用
- 💰 融资/商业 — 融资、收购、商业合作
- 🛡️ 安全/治理 — AI安全、监管、伦理
- 🔧 应用/产品 — 新产品、功能更新
- 🔓 开源 — 开源模型、工具、框架

## 配置

在你的 TOOLS.md 中添加：
```markdown
### AI News ZH
- 推送时间：07:30 (Asia/Shanghai)
- 推送渠道：feishu（或 telegram/discord）
- 新闻条数：10-12条/天
- 语言：中文
```

## 采集流程

1. 依次抓取各数据源（web_fetch）
2. 提取标题、摘要、来源、时间
3. 筛选AI相关内容，去除非AI新闻
4. 与已采集内容去重
5. 翻译为中文，添加分类标签
6. 按重要性排序，选取Top 10-12
7. 格式化为日报并推送

## 注意事项
- 需要 web_fetch 工具（必需）
- web_search 可大幅提升采集能力（可选，需Brave API key）
- 中文源（36kr、量子位等）需要 browser 工具（可选）
- 首次使用建议手动触发一次，确认格式和渠道
