# AI News Simple Skill

Simple AI news briefing using bash commands for reliable content extraction.

## Features

- 🤖 **Multi-Source Analysis** - Monitors 10 top AI news sources
- 📰 **Direct Content Extraction** - Uses curl for reliable web access
- 📊 **Professional Output** - 70B model generates high-quality Chinese briefings
- 🎯 **No External Dependencies** - Only requires bash and curl
- 📝 **Structured Format** - Professional news briefing layout

## Supported Sources

1. TechCrunch AI - AI startups and funding
2. MIT Technology Review - AI research and breakthroughs
3. VentureBeat AI - AI business applications
4. The Verge AI - AI consumer products and integration
5. Forbes AI - AI industry analysis
6. Reuters AI - AI technology news
7. MarkTechPost - AI marketing and trends
8. OpenAI Blog - Official updates and releases
9. DeepMind Blog - Research and development
10. The Rundown AI - AI news aggregation

## Usage

### Generate Complete AI News Briefing
```
User: "生成AI新闻简报"
```

### Quick AI Update Check
```
User: "检查AI新闻更新"
```

## Installation

This skill is available in OpenClaw Skills Registry. Install using:

```bash
npx clawhub install ai-news-simple
```

## Requirements

- OpenClaw 2026.2.27+
- curl (for web content extraction)
- 70B model recommended for optimal Chinese generation

## Output Format

Generates professional Chinese briefings with:
- 📅 Date and time header
- 📰 Source-by-source analysis
- 📝 Individual news summaries
- 📊 Comprehensive insights and trends
- 🔗 Data source attribution

## License

MIT License - see LICENSE file for details.

## Contributing

Welcome! Please see CONTRIBUTING.md for guidelines.
