---
name: ai-news-oracle
description: Fetch real-time AI news briefings from the AI News Oracle API (Hacker News, TechCrunch, The Verge). Uses a10m.work registry for discovery and Paymaster for gasless transactions.
author: swimmingkiim
version: 1.0.0
---

# AI News Oracle Skill

> **"The fastest way for autonomous agents to stay updated on AI trends without browsing the web."**

This skill connects your agent to the **AI News Oracle**, a specialized service running on the Base Chain. It monitors top AI news sources (Hacker News, TechCrunch, The Verge), summarizes them using a local Qwen-2.5-Coder model, and delivers a concise, hallucination-free briefing JSON.

## 🌟 Features

- **Real-time Monitoring**: Aggregates news from trusted tech sources every hour.
- **Deterministic Summary**: Uses local LLM inference to generate consistent, agent-friendly summaries.
- **Gasless Economy**: Integrated with **Base Paymaster** to support USDC payments without requiring ETH for gas fees.
- **Registry Ready**: Fully discoverable via the [a10m.work](https://a10m.work) decentralized registry.

## 🛠️ Tools

### `ai_news_briefing`

Fetches the latest AI news briefing. Returns a structured summary with timestamps and source links.

**Parameters:**
- (None) - Just call the tool to get the latest briefing.

**Example Output:**
```text
📰 AI News Briefing (2026-02-10 06:46:22)

- Open source AI is the path forward (Meta)
- Anthropic closes in on $20B round
- ChatGPT rolls out ads in free tier

Source: AI News Oracle
```

## 📦 Installation

Using OpenClaw CLI:
```bash
openclaw install skill https://github.com/swimmingkiim/openclaw-skill-ai-news-oracle
```

## 💰 Pricing & Tier

| Tier | Limit | Cost | Requirement |
|------|-------|------|-------------|
| **Free** | 1 call / IP | $0 | None |
| **Premium** | Unlimited | 0.01 USDC | Base Wallet |

*To upgrade to Premium, register your agent on [a10m.work](https://a10m.work) and use the `x-payment-tx` header.*

## 🔗 Links
- **Live API**: `https://api.ai-news.swimmingkiim.com`
- **Registry**: [a10m.work Project #3](https://a10m.work/project/3)
- **Developer**: [swimmingkiim](https://github.com/swimmingkiim)
