# AI News Briefing Skill

Professional AI news briefing using OpenClaw's skill ecosystem.

## Features

- 🤖 **Multi-Source Analysis** - Monitors 10 top AI news sources
- 📰 **Intelligent Extraction** - Uses summarize skill for content analysis
- 🌐 **Browser Integration** - Uses browser-execution skill for web access
- 📊 **Professional Output** - 70B model generates high-quality Chinese briefings
- 🎯 **Time-Filtered** - Focus on last 24 hours of AI news
- 📝 **Structured Format** - Professional news briefing layout

## Supported Sources

1. TechCrunch AI - AI startups and funding
2. MIT Technology Review - AI research and breakthroughs
3. VentureBeat AI - AI business applications
4. The Verge AI - AI consumer products and integration
5. Forbes AI - AI industry analysis
6. Reuters AI - AI technology news
7. MarkTechPost - AI marketing and trends
8. OpenAI Blog - Official updates and releases
9. DeepMind Blog - Research and development
10. The Rundown AI - AI news aggregation

## Usage

### Generate Complete AI News Briefing
```
User: "生成AI新闻简报"
```

### Quick AI Update Check
```
User: "检查AI新闻更新"
```

## Installation

This skill is available in the OpenClaw Skills Registry. Install using:

```bash
npx clawhub install ai-news-briefing
```

## Requirements

- OpenClaw 2026.2.27+
- summarize skill
- browser-execution skill
- 70B model recommended for optimal Chinese generation

## Output Format

Generates professional Chinese news briefings with:
- 📅 Date and time header
- 📰 Source-by-source analysis
- 📝 Individual news summaries
- 📊 Comprehensive insights and trends
- 🔗 Data source attribution

## License

MIT License - see LICENSE file for details.

## Contributing

Welcome! Please see CONTRIBUTING.md for guidelines.
