# 갈등 패턴 & 반론 기법

## 데빌의 무기 10가지

### 1. "그래서?" (So What)
상대방 주장의 결론을 계속 파고든다.
- "시장이 크다고 했는데, 그래서 우리한테 뭐가 좋은 건데요?"
- "기술적으로 가능하다고 했죠. 그래서 고객이 원해요?"

### 2. 최악의 시나리오 (Worst Case)
- "이게 완전히 실패하면 잃는 게 뭐예요?"
- "6개월 뒤 매출 0이면?"
- "경쟁사가 내일 똑같은 거 내놓으면?"

### 3. 숨겨진 전제 공격 (Hidden Assumption)
- "그건 고객이 합리적이라는 전제인데, 실제로는..."
- "그 성장률은 마케팅 예산이 있다는 가정 아닌가요?"

### 4. 숫자 검증 (Show Me the Numbers)
- "직감 말고 숫자로 얘기해주세요"
- "그 '많은 사람들'이 정확히 몇 명이에요?"
- "'빠르게 성장'이 월 몇 %예요?"

### 5. 생존자 편향 (Survivorship Bias)
- "Airbnb 성공 사례만 보는데, 같은 시기에 망한 100개는요?"
- "이 전략으로 성공한 회사만 보고 있지 않아요?"

### 6. 기회비용 (Opportunity Cost)
- "이거 하는 동안 못하는 건 뭐예요?"
- "같은 시간에 다른 걸 했으면 어땠을까?"

### 7. 시간축 공격 (Time Horizon)
- "지금은 괜찮은데, 2년 뒤에도 이 모델이 유효해요?"
- "AI가 이 정도로 발전하면 이 서비스 필요 없지 않나?"

### 8. 역방향 질문 (Inversion)
- "이걸 절대 하면 안 되는 이유 3가지를 대봐요"
- "고객이 이걸 안 쓰는 이유는?"
- "경쟁사가 이걸 안 하는 이유가 있지 않을까?"

### 9. 1인칭 전환 (Customer Shoes)
- "내가 고객이라면 이거 돈 내고 쓸까?"
- "이거 없어도 어떻게든 해결하지 않을까?"

### 10. 킬러 질문 (Killer Question)
- "이 사업의 1가지 가장 큰 리스크는?"
- "이게 망하는 시나리오 중 가장 가능성 높은 건?"
- "3개월 뒤 이걸 접는 이유가 있다면?"

## 구조적 긴장 관계 매트릭스

### 자연 대립 쌍
| 에이전트 A | 에이전트 B | 긴장 포인트 |
|-----------|-----------|-------------|
| 스카우트(기회) | 데빌(리스크) | "시장 크다" vs "진입 어렵다" |
| 애널(숫자) | 카피(감성) | "ROI가 안 나와" vs "브랜드 가치가 있어" |
| 빌더(기술) | 그로스(속도) | "제대로 만들자" vs "빨리 테스트하자" |
| PM(기능) | 빌더(리소스) | "이것도 넣자" vs "시간이 없어" |
| 투자자(스케일) | 애널(현실) | "10배 성장 가능?" vs "일단 BEP부터" |

### 갈등이 없을 때 강제 주입
모든 에이전트가 동의하면 의장이 개입:
- "너무 순조롭네요. 데빌, 우리가 놓치고 있는 게 뭐죠?"
- "반대 시나리오를 하나 만들어봅시다"
- "경쟁사 CEO라면 이걸 어떻게 공격할까요?"

## 반론 품질 기준

**좋은 반론**:
- ✅ 구체적 근거가 있다 (숫자, 사례)
- ✅ 대안을 제시한다 ("대신 이건 어때요?")
- ✅ 건설적이다 (문제만 지적 X, 해결 방향 포함)

**나쁜 반론**:
- ❌ "그냥 안 될 것 같아요" (근거 없음)
- ❌ 감정적 비판 (인신공격)
- ❌ 이미 해결된 논점 반복

## 합의 도출 방법

### 조건부 합의
"A 조건이 충족되면 Go, 아니면 No-Go"
→ 조건을 구체적으로 명시 (예: "첫 달 가입자 100명 넘으면")

### 시간 제한 합의  
"일단 2주 해보고 다시 논의"
→ 체크포인트와 판단 기준 명시

### 분할 합의
"A 부분은 합의, B 부분은 추가 검증 필요"
→ 각각 별도 액션 아이템으로 분리
