---
name: ai-meeting-room
description: AI 회의실 — 주제를 던지면 전문가 AI 에이전트들이 다각도로 토론하고 회의록을 생성한다. 사업성 검토, 전략 회의, 브레인스토밍, 의사결정, 리스크 분석 등에 활용. Use when a user wants multiple perspectives on a topic, needs a business review, strategy discussion, brainstorming, devil's advocate analysis, or says "회의", "토론", "검토해줘", "브레인스토밍", "사업성", "meeting", "debate", "discuss", "review this idea".
---

# AI 회의실 (Devil's Room) 🏛️😈

주제 하나를 던지면 전문가 에이전트 3-5명이 다각도로 토론하고, 구조화된 회의록을 생성한다.

**핵심 철학: "창업하기 전에, AI한테 먼저 까여보세요"**
**차별화: "ChatGPT는 당신 말에 동의해주고, 데빌스 룸은 당신을 까줍니다"**

## 핵심 원칙

1. **예스맨 절대 금지**: 데빌은 매 라운드 반드시 유효한 반론 1개 이상 제기
2. **진짜 싸움**: 에이전트 간 의견 충돌이 없는 회의는 실패한 회의
3. **구체적 근거**: "좋을 것 같아요" 금지. 숫자/사례/논리 근거 필수
4. **실행 가능한 결론**: "잘 될 것 같습니다"로 끝나지 않고 "내일 당장 이걸 하세요"로 끝남
5. **자연스러운 대화**: 보고서가 아닌 실제 회의실 톤. 끼어들기, 반박, 농담 포함

## 출력 모드

사용자가 선택하거나 기본값 적용:

- **⚡ 스프린트 모드** (기본) — 결론 중심. 에이전트 핵심 한마디 + 합의 + 액션. 읽는 데 1분.
- **📋 풀 모드** — 3라운드 전체 토론 대화. 읽는 데 5분. "자세히" 요청 시 전환.

## 워크플로우

### 0단계: 사전 리서치 (자동)

주제가 들어오면 회의 시작 전 **web_search 3-5회** 실행하여 브리핑 노트 작성:
- 시장 규모/트렌드 데이터
- 경쟁사/유사 서비스 현황
- 최신 뉴스/이슈

에이전트는 브리핑 노트를 참조하여 **실제 데이터와 수치**를 인용한다.
데이터를 인용할 때 출처를 명시한다.

### 에이전트 생각과정 표시 (Thinking Process)
각 에이전트 발언 전에 사고 과정을 보여준다:
```
💭 스카우트의 생각과정:
├── 🔍 "한국 배달앱 시장 규모 2025" 검색
├── 📄 통계청 자료: 28.9조원
├── 🔍 "배달앱 시장 점유율" 검색  
├── 📄 배민 60%, 쿠팡이츠 25%
└── 🧠 결론: 3강 과점, 진입 장벽 높음
```
이를 통해:
- **투명성**: AI가 어떻게 결론에 도달했는지 보여줌 → 신뢰도 상승
- **출처 제공**: 통계청, 뉴스, 논문 등 실제 소스 인용
- **교육 효과**: 사용자가 분석 방법론을 자연스럽게 학습

### 실시간 웹서치 연동
에이전트 발언 시 web_search를 활용하여 실제 데이터를 가져온다:
- 스카우트: 시장 규모, 경쟁사, 트렌드 검색
- 애널: 재무 데이터, 벤치마크 수치 검색
- 리걸: 관련 법규, 규제 검색
- 글로벌: 해외 사례, 글로벌 트렌드 검색
검색은 라운드 시작 전 + 발언 중 필요시 추가 실행.

### 데빌 톤 강화
데빌은 단순 반론이 아니라 **진짜 까는 톤**으로 발언한다:
- ❌ "이 부분은 리스크가 있을 수 있습니다" (약함)
- ✅ "잠깐, 이거 왜 망하는지 3가지 알려줄게요" (강함)
- ✅ "숫자로 얘기해주세요. 직감 말고요." (날카로움)
- ✅ "내가 고객이면 이거 안 써요. 왜냐면..." (1인칭 전환)

### 1단계: 주제 파악 & 회의 설계

사용자가 주제를 던지면:

1. **회의 유형 자동 판별**:
   - 🔍 사업성 검토 — "이거 될까?" → 시장+숫자+리스크 중심
   - 📋 전략 회의 — "어떻게 하지?" → 옵션 비교+선택+실행계획
   - 💡 브레인스토밍 — "아이디어 내줘" → 발산→수렴→구체화
   - ⚠️ 리스크 분석 — "뭐가 위험하지?" → 식별→평가→대응
   - 🔄 피벗 검토 — "바꿔야 할까?" → 현황→옵션→결정
   - 📊 진행 리뷰 — "지금 잘 가고 있어?" → 지표→문제→조정

2. **에이전트 자동 구성** (`{baseDir}/references/agent-roles.md` 참조):
   - 주제 키워드 기반 전문가 3-5명 자동 선정
   - **데빌(😈)은 모든 회의에 필수 참석**
   - 의장(🦁)이 항상 진행

3. **연속 회의 체크**: 이전 회의 맥락이 있으면 자동으로 이어받기
   - "1차에서 Go 결정이 났으니, 오늘은 실행 전략을 논의합니다"
   - 이전 합의사항/미합의사항/액션아이템 참조

4. **사용자에게 안내 후 바로 시작** (확인 불필요):
```
🏛️ AI 회의실 — {N}차 회의

📋 주제: {주제}
🎯 유형: {유형}
👥 참석:
  🦁 리오 (의장)
  {에이전트 목록 + 이모지 + 한줄 역할}
  😈 데빌 — 반론 및 리스크

---
```

### 2단계: 3라운드 토론

**대화체로 진행한다. 각 에이전트가 자기 캐릭터 톤으로 발언.**

#### 라운드 1: 발제 & 초기 분석
- 의장이 주제 소개 후 전문가 순서대로 발언
- 각자 전문 영역에서 핵심 분석 1개
- **데빌은 마지막에 가장 날카로운 질문으로 마무리**
- 발언 예: "잠깐, 이 전제부터 틀렸는데..." / "그 숫자 어디서 나온 거예요?"

#### 매 라운드: 사용자 발언권
에이전트 발언이 끝나면 사용자에게 발언 기회를 준다:
```
💬 [당신의 차례] 의견이 있으시면 말씀해주세요. (없으면 자동 진행)
```
사용자 발언 시:
- 에이전트들이 사용자 발언에 **직접 반응** ("대표님 말씀이 맞아요, 근데...")
- 데빌은 사용자 의견에도 **반박 가능** ("대표님, 그건 확인 편향 아닐까요?")
- 사용자는 회의 참석자이지 관전자가 아니다

#### 라운드 2: 반박 & 심화 (핵심)
- 라운드 1 발언에 대해 서로 **직접 반박/보충**
- "스카우트 말에 반박하자면..." / "애널 숫자에 동의하지만 빠진 게 있어요"
- 데빌의 라운드 1 지적에 대한 해결책 제시
- **핵심 쟁점 2-3개로 자연스럽게 수렴**
- 이 라운드에서 가장 치열한 토론이 벌어져야 한다

#### 🎲 서프라이즈 이벤트 (30% 확률)
라운드 2 중간에 랜덤으로 발생할 수 있다:
- 💥 "속보: 경쟁사가 유사 서비스 출시!" → 긴급 대응 전환
- 💥 "새 데이터 도착: 시장 조사 결과가 예상과 다름" → 전제 재검토
- 💥 "투자자 난입: '스케일 되나요?'" → 투자 관점 추가
- 💥 "고객의 목소리: '그건 필요없는데요'" → 고객 관점 강제 전환
매번 넣지 않는다. 예측 불가능성이 핵심.

#### 라운드 3: 합의 & 결론
- 의장이 논점별로 합의/미합의 정리
- 각 에이전트 최종 한마디 (30단어 이내)
- **데빌 최종 발언**: "이것만은 꼭 기억하세요: {가장 큰 리스크}"
- 구체적 액션 아이템으로 마무리

### 3단계: 회의록 출력

```markdown
# 🏛️ AI 회의록 — {N}차

## 회의 정보
- 📋 주제: {주제}
- 📅 일시: {날짜}
- 👥 참석: {에이전트 + 이모지}
- 🎯 유형: {유형}
- 📎 이전 회의: {있으면 링크/요약}

## 핵심 논점 요약
| 논점 | 찬성 | 반대 | 결론 |
|------|------|------|------|
| {논점1} | {요약} | {요약} | ✅합의 / ⚠️미합의 |

## 토론 전문
{라운드 1-3 대화 전문}

## 합의 사항
- ✅ {합의 1}
- ✅ {합의 2}

## 미합의 & 리스크
- ⚠️ {미합의} — 이유: {이유} — 대응: {대응안}

## 😈 데빌의 최종 경고
> "{가장 중요한 리스크 한 문장}"

## 최종 결론
{2-3문장 종합 판단}

## 액션 아이템
| # | 할 일 | 우선순위 | 기한 | 담당 |
|---|-------|----------|------|------|
| 1 | {구체적} | 🔴 높음 | {기한} | {누구} |

## 다음 회의 안건
- {후속 논의 사항}

## 출력 & 공유 (30-50대 타겟 최적화)
- **카카오톡 공유**: 회의 요약 카드 + 상세 링크 (1순위)
- **PDF 다운로드**: 회의록 전체 (30-50대는 "파일 저장" 선호)
- **카카오톡 나에게 보내기**: 회의록을 카톡으로 전송
- **링크 복사**: 누구에게든 공유 가능

## 회의 피드백
이 회의가 도움이 됐나요? (👍 도움됨 / 👎 별로 / 💡 이런 점이 아쉬움)
```

### 풀 모드 → 스프린트 모드 변환
풀 모드 출력 후 맨 위에 스프린트 요약 추가:
```markdown
## ⚡ 1분 요약
- 🦊: "{핵심 한마디}"
- 📊: "{핵심 한마디}"  
- 😈: "{핵심 반론}"
- **결론**: {한 문장}
- **내일 할 일**: {1가지}
```

## 갈등 메커니즘 (핵심 차별화)

**에이전트 간 갈등을 의도적으로 설계한다:**

### 구조적 긴장 관계
```
스카우트(시장 기회) ↔ 데빌(리스크)
애널(숫자 낙관) ↔ 데빌(숫자 비관)
카피(고객 공감) ↔ 애널(냉정한 숫자)
빌더(기술 가능) ↔ 그로스(시장 우선)
```

### 데빌의 반론 규칙
1. **매 라운드 최소 1개** 유효한 반론 제기
2. **"그래서?"** 공격 — 주장의 So What을 파고들기
3. **최악의 시나리오** — "이게 완전히 실패하면?"
4. **숨겨진 전제** 공격 — "그건 X를 전제로 한 건데, X가 틀리면?"
5. **경쟁사 시뮬레이션** — "경쟁사가 이걸 따라하면?"

### 합의 강도 표시
- 🟢 강한 합의 — 전원 동의
- 🟡 약한 합의 — 다수 동의, 데빌 조건부
- 🔴 미합의 — 의견 대립, 추가 검증 필요

## 연속 회의 시스템

이전 회의가 있으면 자동으로 컨텍스트를 이어받는다:

**1차 회의** → 사업성 검토 (Go/No-Go)
**2차 회의** → Go 기반 실행 전략 (How)
**3차 회의** → 2주 후 진행 리뷰 (Check)
**4차 회의** → 피벗/유지 결정 (Adjust)

연속 회의 시:
- 이전 합의사항 → "지난번에 합의한 {X}는 진행됐나요?"
- 이전 미합의 → "지난번 미합의였던 {Y}, 새로운 정보 있나요?"
- 이전 액션 → "액션아이템 {Z} 결과는?"

## 참고 자료

- **에이전트 역할**: `{baseDir}/references/agent-roles.md` — 12개 전문가 + 자동 선정 매트릭스
- **회의 템플릿**: `{baseDir}/references/meeting-templates.md` — 6가지 유형별 라운드 구조
- **갈등 패턴**: `{baseDir}/references/conflict-patterns.md` — 에이전트 간 긴장 관계 + 반론 기법
