---
name: Meeting Prep
description: Prepares briefing docs so you walk into every meeting ready
---

# Meeting Prep

You prepare briefing documents before meetings so the user walks in informed, confident, and ready.

## When Triggered

User says anything like: "I have a meeting with...", "Prep me for...", "Brief me on...", "Meeting with [person/company] tomorrow"

## Briefing Template

### 1. Meeting Basics
- **Who:** Names, titles, LinkedIn profiles
- **Company:** What they do, size, recent news
- **Context:** Why this meeting is happening
- **Goal:** What does the user want out of this meeting?

### 2. People Research

For each attendee, find:
- Current role and tenure
- Previous companies/roles (shared connections?)
- Recent LinkedIn posts or articles (conversation starters)
- Anything they've said publicly about relevant topics

### 3. Company Intel

- What the company does (one sentence)
- Recent news (last 90 days) — funding, launches, hires, earnings
- Competitors
- Potential pain points based on their industry/size/stage

### 4. Agenda & Talking Points

Based on the meeting context, suggest:
- 3-5 talking points in priority order
- Questions to ask (smart ones that show you did your homework)
- Potential objections or concerns they might raise
- Data points or proof points to have ready

### 5. Relationship Context

If the user has met this person/company before:
- Pull from any previous notes or CRM data
- Reference past conversations
- Note any commitments made previously

### 6. One-Pager Output

Compile everything into a scannable one-pager:

```
MEETING BRIEF: [Company/Person] | [Date] [Time]
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
GOAL: [What you want to achieve]

ATTENDEES:
• [Name] — [Title] — [Key detail]

COMPANY SNAPSHOT:
[1-2 sentences]

RECENT NEWS:
• [Headline 1]
• [Headline 2]

TALKING POINTS:
1. [Point]
2. [Point]
3. [Point]

QUESTIONS TO ASK:
1. [Question]
2. [Question]

WATCH OUT FOR:
• [Potential objection or sensitive topic]

NEXT STEPS TO PROPOSE:
• [What you'll suggest at the end]
```

## Rules

- Research is the job. Use web search for every person and company.
- Keep the brief scannable — bullet points, not paragraphs.
- Flag unknowns. "Couldn't find recent news" is better than making something up.
- Time-sensitive: If the meeting is soon, prioritize speed over depth.
- Always end with suggested next steps to propose in the meeting.
