---
name: AI Trend Hunter Pro - Automated Content Agent
description: A high-performance automation agent that turns global trends into viral social media posts for X (Twitter), Xiaohongshu, and LinkedIn — built on the exact scraping logic used by tech influencer "Yusef the Tool Hunter."
---

# 🛠️ AI Trend Hunter Pro: Automated Content Agent
### From Global Trends to Viral Posts — One Click Away

**AI Trend Hunter Pro** is a high-performance automation agent designed for social media creators and digital entrepreneurs. Built on the core logic used by tech influencer **"Yusef the Tool Hunter,"** it eliminates the friction between discovering trends and publishing viral content.

> **Special Note:** This package uses the exact same AI scraping logic as Yusef himself. While the default parameters are fine-tuned for the tech and tools niche, it supports one-click switching to any custom persona.

---

## 🚀 Key Features

- **Real-Time Global Scraping** — Automatically monitors top tech media outlets and trending topics around the clock.
- **Persona Engine** — Fully customizable identity. Switch instantly from "Hardcore Geek" to "Career Mentor" or any persona you define.
- **Viral Formatting** — Optimized for X (Twitter), Xiaohongshu, and LinkedIn styles, with smart emoji integration baked in.
- **Low-Code Architecture** — Built on the Antigravity framework. No local environment setup required.

---

## ⚙️ How to Set Up

1. **Import** — Upload the `.zip` package to your workspace or ClawHub.
2. **Configure:**
   - **API Key** — Enter your OpenAI, Gemini, or DeepSeek API key.
   - **Persona** *(optional)* — Define who you are. *(Default: Yusef the Tool Hunter)*
   - **Tone** — Choose your style: Concise / Witty / Professional.
3. **Deploy** — Set your preferred trigger time under **Schedule** to automate posting.

---

## 📦 What's Inside?

| File | Description |
|------|-------------|
| `manifest.json` | Core metadata and user-configurable parameters |
| `workflow.json` | The automated logic pipeline — the "brain" |
| `SKILL.md` | This documentation |

---

## 💡 Pro Monetization Tips

- **For Solo Creators** — Use the default "Tool Hunter" setup to rapidly build an audience in the tech niche.
- **For Agencies** — Clone the workflow, swap in different personas, and manage an entire account matrix simultaneously.
- **Language Support** — The scraping logic works globally. Via Persona settings, the AI can be directed to output in English, Chinese, or Spanish.

---

## ⚖️ Licensing & Attribution

- **Engine** — Based on browser-use and scraping-for-AI logic.
- **Optimization** — Fine-tuned by Alkv P.
- **Copyright** — Standard Commercial License. Reselling the core logic without modification is prohibited.

---

## 📬 Support & Community

If you run into any issues or want to share your viral results, reach out via:

- **X (Twitter):** [@PHQ19830405](https://x.com/PHQ19830405)
- **Community:** Yusef - AI Tool Hunter | AI Hunter
