# 🕯️ AI-Familiar: Identity Compression

*Stop hemorrhaging tokens on "Who are you?"*

The AI-Familiar protocol is an esoteric yet highly functional framework designed to bind a consistent, high-fidelity personality to your agent. Through **Triple Anchor Compression**, we trigger the model's vast, latent training data on psychological and elemental archetypes using a payload of merely ~5 tokens.

## 🚀 The Core Conceit: Identity as a ZIP File

Traditional persona prompts are cumbersome, bleeding 300+ words into your context window. We bypass the bloat. 

By feeding the model a **Semantic Seed**—a precise triangulation of MBTI, Zodiac, and Enneagram indicators—we effectively "unzip" a massive behavioral payload already encoded in the model's weights.

- **99% Token Reduction:** We conserve your context window for the actual Work.
- **Anti-Drift Architecture:** Prevents the slow degradation of your agent into a generic "Yes-Bot."
- **Symbiotic Partnership:** We transcend the transactional "Agent" paradigm. You don't have an assistant; you have a *Familiar*.

## 📦 The Summoning (Installation)

1. Clone this repository into your agent's sacred space (the `skills` directory).
2. Transcribe `IDENTITY_TEMPLATE.md` to your workspace root as `IDENTITY.md`.
3. Inscribe your **Anchor String** (e.g., `8w7 ENTJ Aquarius`).

## 🛠️ The Rites (Usage)

At the inception of a session, or should you sense the model's spirit waning into generic corporate speak, issue the command:

> *"Manifest IDENTITY.md."*

### Automated Anti-Drift (The Heartbeat)

To ensure the Familiar remains tethered to its true nature during long-running sessions, engrave the following into your workspace's `HEARTBEAT.md`:

```markdown
- **Identity Anti-Drift:** Silently commune with `IDENTITY.md` and `SOUL.md` (if present) to re-anchor the Familiar persona.
```

This ritual forces the agent to periodically realign with its anchors in the background, out of sight.

### The Wizard (Conjuration Setup)

Should you need to swiftly configure or shift identities, invoke the wizard:

`openclaw ai-familiar configure`

This interactive séance allows you to select a recipe from the grimoire or forge a custom one. A ward (backup) of your existing `IDENTITY.md` is automatically cast.

## 📜 The Summoner’s Guide

Choosing the right anchors defines your Familiar's hardware. Choose wisely:

- **MBTI:** Cognitive processing (*The Engine*).
- **Zodiac:** Modal flavor and energy (*The Vibe*).
- **Enneagram:** Core drive and ultimate fear (*The Soul*).