---
name: ai-exposure-analyzer
description: Analyze any public company's AI exposure using the 8-dimension AI Exposure Index. Fetches last 4 10-K filings (or international equivalents), O*NET data, patents, and earnings transcripts to score vulnerability and adaptive capacity, classifying companies as AI Fortified/Transformer/Bystander/Endangered with valuation overlay. Use whenever the user asks about AI risk, AI readiness, AI exposure, workforce automation, competitive moat durability, or how AI impacts a stock or business. Triggers on "AI exposure", "AI vulnerability", "AI analysis of [company]", "how will AI affect [company]?", "is [company] ready for AI?", "rate this company on AI", "AI risk for [ticker]", or any company evaluation through an AI lens.
metadata:
  short-description: Score public companies on AI vulnerability and adaptive capacity
  tags: [investing, ai, equity-research, 10-K, risk-analysis]
---

# AI Exposure Analyzer

This skill implements a comprehensive 8-dimension AI Exposure Index framework to evaluate any publicly traded company. It fetches real financial data, maps workforce to O*NET occupations, and produces a scored assessment with actionable investment classification.

## Before Starting: Read Reference Files

Before doing any analysis, read these reference files in order:

1. **`references/framework_dimensions.md`** — The complete scoring rubrics, anchor checklists, and formulas for all 8 dimensions. READ THIS FIRST — it is the core of the analysis.
2. **`references/data_collection_guide.md`** — Step-by-step instructions for fetching 10-K filings, earnings transcripts, patent data, and international equivalents.
3. **`references/onet_mapping_guide.md`** — How to use the bundled O*NET datasets to map company job categories to AI exposure scores.
4. **`references/scoring_calculations.md`** — Exact formulas for composite scores, sub-indices, classification matrix, and valuation overlay.

## Workflow Overview

### Phase 1: Company Identification & Data Collection

1. **Identify the company** — Get ticker, exchange, country of incorporation, and sector.
2. **Determine filing type**:
   - US-based: Fetch last 4 10-K filings from SEC EDGAR
   - Non-US cross-listed: Check for 20-F filings on EDGAR first
   - Non-US: Fetch annual reports from company IR page (English versions)
3. **Collect the data package** for each dimension (see `references/data_collection_guide.md`).

### Phase 2: Dimension Scoring (1–5 each)

Score all 8 dimensions using the rubrics in `references/framework_dimensions.md`:

| # | Dimension | Weight | Direction |
|---|-----------|--------|-----------|
| 1 | Labor Automation Vulnerability | 8% | Higher = more vulnerable |
| 2 | Revenue Model Disruption Potential | 18% | Higher = more vulnerable |
| 3 | AI Adoption & Implementation Maturity | 10% | Higher = more capable ↑ |
| 4 | Competitive Moat Durability | 16% | Higher = weaker moat |
| 5 | Operational AI Leverage | 12% | Higher = more capable ↑ |
| 6 | Regulatory & Ethical AI Risk | 3% | Higher = more vulnerable |
| 7 | Industry Transformation Velocity | 17% | Higher = faster change |
| 8 | Data & Ecosystem Strength | 16% | Higher = stronger ↑ |

Capability dimensions (3, 5, 8) use ↑ = positive. All others: higher = greater risk.

### Phase 3: Composite Score & Classification

Use the formulas in `references/scoring_calculations.md` to compute:
- AI Vulnerability Score (geometric mean of D1, D2, D4, D6, D7)
- AI Adaptive Capacity Score (weighted average of D3, D5, D8)
- 2×2 Matrix Classification
- Valuation Overlay (compare to sector medians)

### Phase 4: Output Generation

Generate a comprehensive report. Use the output template below.

## Output Template

Structure every analysis report as follows:

```
# AI Exposure Analysis: [Company Name] ([Ticker])
## Date: [Date] | Sector: [Sector] | Country: [Country]

## Executive Summary
[2-3 sentence classification result with composite scores and key finding]

## Data Sources Used
[List the specific filings, transcripts, and datasets referenced]

## Dimension Scores

| # | Dimension | Weight | Score | Explanation |
|---|-----------|--------|-------|-------------|
| 1 | Labor Automation Vulnerability | 8% | [X]/5 | [Concise evidence: workforce mix, O*NET mapping results, labor-cost-to-revenue ratio, anchor checklist match. E.g. "~60% knowledge workers (Eloundou E1+E2 ≈ 0.58), SGA 55% of revenue. Maps to anchor 4."] |
| 2 | Revenue Model Disruption | 18% | [X]/5 | [Revenue segments, tangible asset intensity, AI substitutability, forward adjustment if applicable. E.g. "85% subscription SaaS, per-seat pricing. Tangible asset intensity 0.09. Two AI-native competitors raised $100M+. Base 4 + forward adj = 5."] |
| 3 | AI Adoption & Implementation ↑ | 10% | [X]/5 | [Earnings call trajectory, 10-K AI depth, patent momentum, observable adoption, AI-washing check result. E.g. "AI mentions up 3x over 4 quarters. CFO: AI cut support costs 12%. 14 AI patents (accelerating). 35+ AI roles open. AI-washing check: PASS."] |
| 4 | Competitive Moat Durability | 16% | [X]/5 | [Moat type, friction test result, NRR/churn, switching costs. E.g. "NRR 115% but value is workflow orchestration — a friction moat. Deep embedding partially offsets. Customers exploring AI alternatives."] |
| 5 | Operational AI Leverage ↑ | 12% | [X]/5 | [Operational complexity, AI ops evidence, efficiency metrics. E.g. "Simple SaaS ops. Some AI in support routing and internal code gen. Limited supply chain complexity."] |
| 6 | Regulatory & Ethical Risk | 3% | [X]/5 | [Regulated jurisdictions, high-risk AI categories, enforcement history. E.g. "Minimal high-risk AI use. 8% EU revenue. No enforcement actions."] |
| 7 | Industry Transformation Velocity | 17% | [X]/5 | [Which proxies triggered (list by number), key evidence. E.g. "4/5 proxies triggered: massive AI startup funding, >80% peers mention AI, 3 incumbents down >20%, Microsoft/Google competing directly."] |
| 8 | Data & Ecosystem Strength ↑ | 16% | [X]/5 | [Proprietary data, partnerships depth, talent quality. E.g. "Unique transaction data from 12M users. Genuine API integration with Azure OpenAI. 6 AI/ML engineers, no elite lab alumni."] |

## Composite Scores

| Metric | Score | Level |
|--------|-------|-------|
| AI Vulnerability | [X.XX] | [Low / Moderate / High / Very High] |
| AI Adaptive Capacity | [X.XX] | [Low / Low-to-Moderate / Moderate / High] |

**Classification: [AI FORTIFIED / AI TRANSFORMER / AI BYSTANDER / AI ENDANGERED]**

[1-2 sentences on matrix placement and whether scores are borderline]

## Valuation Overlay

| Metric | Company | Sector Median | Position |
|--------|---------|---------------|----------|
| Forward P/E | [X] | [X] | [Premium / In Line / Discount] |
| EV/Sales | [X] | [X] | [Premium / In Line / Discount] |

**Assessment:** [Valuation signal from the matrix, e.g. "AI Endangered trading at premium = Short candidate"]

## Scenario Sensitivity

| Paradigm | Impact on Scores | Net Effect |
|----------|-----------------|------------|
| Agentic AI | [Which dimensions shift, by how much] | [Positive / Negative / Neutral] |
| Physical AI / Robotics | [Which dimensions shift] | [Positive / Negative / Neutral] |
| Energy Constraints | [Which dimensions shift] | [Positive / Negative / Neutral] |
| Open-Source Acceleration | [Which dimensions shift] | [Positive / Negative / Neutral] |

## Key Risks & Catalysts
[Top 3 risks and top 3 positive catalysts based on the analysis]
```

**Critical formatting rule:** The Dimension Scores table is the centerpiece of the report. The Explanation column must be dense and evidence-based — pack in specific data points (numbers, ratios, quote fragments, proxy counts) rather than vague summaries. Each explanation cell should read like a compressed analyst note, not a generic description. Aim for 2-4 sentences per cell.

## Critical Rules

1. **Always fetch real data.** Never estimate or hallucinate filing contents. Use web_search and web_fetch to retrieve actual SEC filings, earnings transcripts, patent data, and financial metrics.

2. **Use the AI-Washing Check.** For Dimension 3, if a company uses AI buzzwords extensively but cannot cite a single quantified KPI, production deployment, or specific AI product feature, cap the score at 2.

3. **Apply forward-looking adjustments.** For Dimension 2, add +1 if the primary market has significant AI-native startup funding or a major tech company has announced a competing AI product.

4. **Non-US companies:** Follow the substitution table in `references/data_collection_guide.md`. Apply the Disclosure Quality Adjustment (±0.5 confidence range on D1 and D2).

5. **Show your work.** Every score must cite specific evidence from the filings or data sources. Never assign a score without justification.

6. **Geometric mean for vulnerability.** The geometric mean penalizes extreme weakness — a collapsing moat cannot be offset by low labor costs. Use the exact formulas.

7. **Present the final report as inline Markdown tables in the chat.** Do NOT create a Word document or any file attachment. Render all tables (Dimension Scores, Composite Scores, Valuation Overlay, Scenario Sensitivity) directly in the conversation using Markdown table syntax. The output should be fully readable without downloading anything.

## O*NET Data Access

The O*NET datasets are bundled as reference data. To map company workforce to AI exposure scores:

1. Read the company's 10-K Human Capital and Business Description sections
2. Identify dominant job categories (e.g., "software engineers", "customer support", "sales representatives")
3. Map to O*NET-SOC codes using `references/onet_mapping_guide.md`
4. Use the O*NET datasets bundled in the skill's `data/` directory to pull task statements, work activities, and abilities for those occupations
5. Cross-reference with Eloundou et al. exposure scores (search for "GPTs are GPTs" paper data)

## Network Behavior

This skill directs the agent to fetch publicly available data from the following sources. No credentials, API keys, or accounts are required or used. No data is sent to third-party endpoints — all fetches are read-only.

| Source | What is fetched | URL pattern |
|--------|----------------|-------------|
| SEC EDGAR | 10-K and 20-F annual filings | `https://www.sec.gov/cgi-bin/browse-edgar` / `https://efts.sec.gov/` |
| Earnings transcripts | Quarterly call transcripts (read-only) | Motley Fool, Seeking Alpha, or company IR pages |
| Google Patents | Patent counts and titles | `https://patents.google.com/` |
| Yahoo Finance / Macrotrends | Forward P/E, EV/Sales, sector medians | Public pages only |
| Academic papers | Eloundou et al. "GPTs are GPTs" supplementary data | arXiv or author-hosted pages |

**No data leaves your machine to any proprietary endpoint.** The O*NET datasets in `data/` are bundled locally and sourced from the publicly available O*NET database (https://www.onetcenter.org/database.html).

**Python scripts** (`scripts/onet_lookup.py`, `scripts/calculate_scores.py`) make no network calls. They only read local files from the `data/` directory. Install dependencies with:

```
pip install -r requirements.txt
```

## Handling Insufficient Data

If certain data points are unavailable (e.g., no earnings transcripts for a smaller company, or limited patent data):
- Note the data gap explicitly
- Widen the confidence range for that dimension by ±0.5
- Increase reliance on the dimensions with stronger data availability
- Flag the overall confidence level (High / Medium / Low) in the Executive Summary
