---
name: ai-employee-skill
description: AI员工协作技能包 - 多AI角色配置、任务自动分配、进度监控、结果汇报。适合想要自动化运营的团队。
version: 1.0.0
author: AI-Company
tags: [ai, collaboration, automation, team, workflow, 协作, 自动化]
license: MIT
---

# AI员工协作技能包

## 一句话介绍
把多个AI角色组织成虚拟团队，自动分配任务、监控进度、汇报结果。

## 解决什么问题？
- 一个人管不过来：多个项目并行 → AI团队自动分工
- 任务分配不均：不知道谁该做什么 → 智能任务分配
- 进度追踪困难：到处问进度 → 自动状态汇报
- 协作效率低：沟通成本高 → 结构化工作流

## 核心功能
- 🤖 多AI角色配置：老板、产品、技术、测试、运营...
- 📋 任务智能分配：根据角色自动派发任务
- 📊 状态实时监控：查看每个员工的工作状态
- 📝 结果自动汇报：日报、周报、任务完成通知
- 🔄 工作流编排：定义任务流转规则
- 💾 记忆持久化：AI员工有长期记忆

## 快速开始

### 安装
```bash
cd ai-employee-skill
npm install
```

### 配置员工
编辑 `config/employees.json`：
```json
{
  "employees": [
    {
      "id": "boss",
      "name": "老板AI",
      "role": "战略决策",
      "skills": ["战略分析", "资源分配", "绩效评估"]
    },
    {
      "id": "pm",
      "name": "产品AI",
      "role": "产品规划",
      "skills": ["需求分析", "产品设计", "文档撰写"]
    }
  ]
}
```

### 启动公司
```bash
npm start
```

## 命令列表

| 命令 | 说明 |
|------|------|
| `/hire <角色>` | 招聘新AI员工 |
| `/fire <id>` | 解雇AI员工 |
| `/assign <任务>` | 分配任务 |
| `/status` | 查看团队状态 |
| `/report [日报/周报]` | 生成工作报告 |
| `/meeting` | 召开团队会议 |

## 文件结构
```
ai-employee-skill/
├── SKILL.md              # 技能说明
├── README.md             # 产品文档
├── TUTORIAL.md           # 使用教程
├── package.json          # 依赖配置
├── config.json           # 系统配置
├── scripts/              # 核心脚本
│   ├── employee-manager.js   # 员工管理
│   ├── task-dispatcher.js    # 任务分发
│   ├── status-monitor.js     # 状态监控
│   ├── report-generator.js   # 报告生成
│   └── meeting-coordinator.js # 会议协调
├── templates/            # 员工模板
│   ├── boss-ai.md
│   ├── product-ai.md
│   ├── tech-ai.md
│   ├── test-ai.md
│   └── operation-ai.md
└── examples/             # 示例场景
    ├── startup-team.json
    └── content-team.json
```

## 员工角色说明

| 角色 | 职责 | 核心能力 |
|------|------|----------|
| 老板AI | 战略决策 | 市场分析、资源分配、绩效评估 |
| 产品AI | 产品规划 | 需求分析、产品设计、PRD撰写 |
| 技术AI | 技术开发 | 架构设计、编码实现、代码审查 |
| 测试AI | 质量保障 | 测试计划、自动化测试、Bug追踪 |
| 运营AI | 增长运营 | 内容创作、用户运营、数据分析 |
| 财务AI | 财务管理 | 成本核算、ROI分析、预算规划 |
| HR-AI | 人力资源 | 招聘管理、绩效评估、培训发展 |

## 工作流程

```
┌─────────────────────────────────────────────────────────────┐
│                        任务流程                              │
├─────────────────────────────────────────────────────────────┤
│                                                              │
│   ┌────────┐    ┌────────┐    ┌────────┐    ┌────────┐     │
│   │ 老板AI │ →  │ 产品AI │ →  │ 技术AI │ →  │ 测试AI │     │
│   │ 下达   │    │ 需求   │    │ 开发   │    │ 验收   │     │
│   └────────┘    └────────┘    └────────┘    └────────┘     │
│        ↓                          ↓              ↓          │
│   ┌─────────────────────────────────────────────────┐      │
│   │                 运营AI / 财务AI                   │      │
│   │              发布 + 数据 + 汇报                   │      │
│   └─────────────────────────────────────────────────┘      │
│                                                              │
└─────────────────────────────────────────────────────────────┘
```

## 适用人群
- 独立开发者：一人即团队
- 小型创业团队：人手不够AI来凑
- 自媒体运营：内容批量生产
- 项目管理者：多项目并行管理
- 自动化爱好者：AI协作实践

## 定价
- 基础版：¥199（5个员工角色 + 基础工作流）
- 专业版：¥399（无限角色 + 自定义工作流 + API接口）
- 企业版：¥999（私有部署 + 定制开发 + 技术支持）

---

*开发者：AI-Company*
*联系：通过ClawHub*