# 剧本生成指南 (Script Generation Guide)

## 分镜剧本表格式

每集剧本输出为结构化的分镜表，每行一个镜头：

| 字段 | 格式 | 示例 |
|------|------|------|
| 镜头号 | ep{NN}_sh{NN} | ep01_sh03 |
| 角色 | 角色名（状态） | 陈易（觉醒前）、张慧芬 |
| 场景 | 场景名/变体 | 医院普通病房/白天 |
| 景别 | 中文 | 近景（胸部以上）、全景、特写 |
| 运镜 | 中文 | 固定、缓推、快拉、左摇、跟拍 |
| 动作描述 | 自然语言 | 张慧芬转身替病床上的陈易整理输液管，轻叹气 |
| 对白 | 引号台词+情绪 | "你的医药费已经拖欠三天了"（无奈叹息） |
| 音效 | 描述 | 输液管碰撞声、脚步远去 |
| BGM | 描述 | 无/紧张鼓点/轻柔钢琴 |
| 原文锚点 | 段落编号 | P-003（改编项目） |

## 剧本写作原则

### 节奏控制
- 每集15-45个镜头（对应1-3分钟）
- 前3秒（前1-2个镜头）必须有视觉冲击或悬念
- 对白场景与动作场景交替，避免连续5个以上纯对话镜头
- 每集结尾必须有钩子（悬念、反转、情绪高点）

### 景别使用
| 景别 | 用途 | 频率 |
|------|------|------|
| 特写 | 情绪爆发、关键道具、表情变化 | 15-20% |
| 近景 | 对话、情绪表达 | 30-40% |
| 中景 | 多人互动、动作 | 25-30% |
| 全景 | 建立场景、群戏 | 10-15% |
| 远景 | 开场/收场、转场 | 5-10% |

### 动作描述要求
- 必须具体到肢体级别："双手快速结印"而非"做出动作"
- 必须包含表情/情绪："眼神犀利如电"而非"看着"
- 多角色场景标明位置关系："画面右侧陈勇背影离去"

### 对白写作
- 每句台词 ≤ 25字（短剧节奏要求）
- 标注说话者和情绪标签
- 金句/名台词从原著保留（改编项目）
- 避免大段独白，用动作打断

## 小说改编特殊规则

### 原文锚点系统
- 对每个镜头标注对应原著段落编号（P-001格式）
- 用于诊断阶段校验忠实度
- 无对应原文的原创镜头标注为"原创"

### 删减与合并原则
- 内心独白 → 转化为面部特写+画外音 或 转化为动作表达
- 大段描写 → 提炼为1-2个关键视觉镜头
- 重复场景 → 合并为节奏更快的蒙太奇
- 次要支线 → 压缩或删除，集中主线

### 保留优先级
1. 核心冲突和转折点（必须保留）
2. 角色金句和名场面（优先保留）
3. 情感高潮和关键对话（优先保留）
4. 环境描写和氛围铺垫（适度保留）
5. 过渡段落和日常场景（可大幅压缩）

## 长篇持续生成

### 每集生成后输出连贯性状态
```json
{
  "episode": 3,
  "character_states": {
    "陈易": { "variant": "觉醒后", "location": "体育馆", "emotion": "自信", "injuries": "无" },
    "林峰": { "variant": "日常", "location": "教练室", "emotion": "震惊" }
  },
  "planted_threads": ["天机古卷的第二个秘密", "王局长的阴谋"],
  "resolved_threads": ["陈易的医药费问题"],
  "props_status": { "天机古卷": "陈易随身携带" },
  "next_hook": "陈易发现古卷中隐藏的第二层文字..."
}
```

### 续写规则
- 开始新一集前先读取上一集的连贯性状态
- 角色服装/位置/情绪必须与上集末尾一致
- 上集钩子必须在本集前3个镜头内有回应
- 已埋伏笔需在合适时机回收（不超过5集）
