# 平台适配器 (Platform Adapters)

## 核心原则

本系统的提示词**统一使用中文自然语言**。各平台适配器在此基础上做格式微调。

---

## 分镜图片提示词 — 平台适配

### 通用基础格式（所有平台共享）

```
{时代}，{场景+环境}，{光影}，{景别}，
{角色名（状态）}+{动作}+{表情}，
{风格}，{质量标签}
```

### Midjourney

```
适配方式：保持中文描述 + 末尾追加MJ参数
后缀：--ar 9:16 --v 6.1 --style raw --s 250
说明：MJ v6 已支持中文描述
角色引用：使用 --cref 传入角色参考图URL
```

### Stable Diffusion / ComfyUI

```
适配方式：中文描述作为正面提示词，另加负面提示词
负面提示词：模糊，低质量，变形，水印，文字，过曝，欠曝
参数：sampler=DPM++ 2M Karras, steps=30, cfg=7, 768×1344
角色引用：LoRA（trigger word=角色名）或 IP-Adapter（参考图）
注意：需支持中文的模型，否则需翻译为英文（保留角色名用拼音）
```

### FLUX

```
适配方式：中文描述直接使用
参数：guidance=3.5, steps=28
说明：FLUX支持中文，但英文更稳定
角色引用：IP-Adapter或LoRA
```

---

## 视频提示词 — 平台适配

### Seedance 1.5 Pro（推荐：有对白场景）

```
适配方式：直接使用中文叙述体视频提示词，几乎无需修改
特性：
  ✅ 支持音画同步（对白自动配口型+声音）
  ✅ 支持切镜指示（"切镜到"会被识别为镜头切换点）
  ✅ 支持角色性别标注（末尾性别声明用于声音匹配）
  ✅ 支持中文自然叙述
参数：duration=5-10s, ratio=9:16
输入：分镜图片作为首帧 + 视频提示词
```

**Seedance是本系统最佳匹配平台**，视频提示词格式与Seedance高度兼容。

### 可灵 (Kling)

```
适配方式：简化视频提示词，去掉切镜，单镜头描述
原因：可灵不支持切镜指示，需将多切镜拆为多个单镜头视频
处理：
  - 原始视频提示词有3个切镜 → 拆为3段可灵提示词
  - 去掉对白部分（可灵不支持音画同步，对白后期配音）
  - 保留角色名字+动作+场景+氛围
参数：duration=5-10s, mode=standard
角色引用：上传角色参考图，提示词中用角色名
```

拆分示例：
```
原始（含3个切镜）→ 拆为：
  可灵片段1：中国现代医院病房，柔和冷光，张慧芬站在病床边，目光望向右侧，陈勇的背影缓缓走出门口
  可灵片段2：医院病房，张慧芬近景，转身面向病床上的陈易，整理输液管，轻叹气，眼神无奈
  可灵片段3：医院病房，张慧芬和陈易同框中景，安静沉重
```

### Runway Gen-3

```
适配方式：翻译为英文描述，单镜头，添加motion参数
原因：Runway英文效果更好
处理：
  - 翻译为英文，角色名用拼音（ZhangHuifen）或角色描述
  - 单镜头，去掉切镜
  - 添加camera_motion和motion_amount参数
参数：motion_amount=1-10, camera_motion=none|push_in|pull_out|pan_left
```

### MiniMax

```
适配方式：简化为中文短描述
格式：{风格}，{场景}，{主体}+{动作}，{氛围}，电影质感
参数：motion_mode=normal|fast
```

---

## 平台选择策略

| 镜头类型 | 首选平台 | 原因 |
|---------|---------|------|
| 有对白的对话场景 | Seedance | 唯一支持音画同步+切镜 |
| 多镜头切换 | Seedance | 识别"切镜到"指令 |
| 角色动作（无台词） | 可灵 | 亚洲面孔效果好，动作自然 |
| 空镜/环境 | Runway | 氛围光影优秀 |
| 快速原型 | MiniMax | 速度快，成本低 |

---

## 跨平台角色一致性方案

最可靠的方案是**图生视频**：

```
分镜图片提示词 → 生成静态分镜图 → 作为视频首帧 → 视频提示词指导动态展开
```

这确保视频画面中的角色外观与分镜图片完全一致。

各平台的角色引用方式：

| 平台 | 角色引用方式 |
|------|------------|
| 即梦/可灵/Seedance | 上传角色参考图，提示词中用名字 |
| SD/ComfyUI（LoRA） | 训练角色LoRA，trigger word = 角色名 |
| SD/ComfyUI（IP-Adapter） | 传入角色立绘作参考 |
| Midjourney | --cref 传入角色参考图URL |
