# 诊断指南 (Diagnosis Guide)

## 五维诊断模型

### 维度1：情节忠实度（35%）
| 检查项 | 评分标准 |
|-------|---------|
| 关键事件覆盖率 | 原著核心事件保留≥90%=满分 |
| 因果链完整性 | 事件间因果逻辑无断裂 |
| 原创偏离度 | 原创内容≤20%且不违背原著精神 |
| 时间线一致性 | 事件顺序无矛盾 |

### 维度2：对白还原度（25%）
| 检查项 | 评分标准 |
|-------|---------|
| 金句保留率 | 原著名台词保留≥80% |
| 口吻匹配度 | 角色说话风格一致 |
| 语气传达 | 情绪表达准确 |
| 信息密度 | 每句台词有效信息≥1个 |

### 维度3：角色一致性（20%）
| 检查项 | 评分标准 |
|-------|---------|
| 性格连贯 | 角色行为符合性格设定 |
| 行为逻辑 | 动机→行为→结果链条合理 |
| 成长弧度 | 角色变化有铺垫不突兀 |
| 关系演变 | 角色间关系变化合理 |

### 维度4：情感曲线（10%）
| 检查项 | 评分标准 |
|-------|---------|
| 节奏匹配 | 张弛有度，不平淡也不过载 |
| 高潮对齐 | 情感高潮与情节高潮同步 |
| 情绪传达 | 观众能感受到预期情绪 |

### 维度5：连贯性（10%）
| 检查项 | 评分标准 |
|-------|---------|
| 上下文衔接 | 与前后集无矛盾 |
| 时空逻辑 | 场景转换合理 |
| 道具连贯 | 道具状态前后一致 |
| 服装连贯 | 角色服装前后一致 |

## 问题严重度

| 级别 | 标记 | 说明 | 处理 |
|------|------|------|------|
| 致命 | 🔴 | 严重违背原著/逻辑错误 | 必须修改 |
| 严重 | 🟠 | 显著偏离但可接受 | 强烈建议修改 |
| 一般 | 🟡 | 可优化但不影响理解 | 建议修改 |
| 轻微 | 🟢 | 微小瑕疵 | 可忽略 |

## 通过标准
- 综合评分 ≥ 75分
- 无致命问题（🔴）
- 严重问题（🟠）≤ 2个

## 诊断模式

| 模式 | 用途 | 触发 |
|------|------|------|
| A: 全量诊断 | 单集完整诊断 | "诊断第N集" |
| B: 增量诊断 | 修改后只查修改部分 | "重新诊断修改的镜头" |
| C: 单维诊断 | 只查特定维度 | "检查角色一致性" |
| D: 对比诊断 | 修改前后对比 | "对比修改效果" |

## 诊断报告格式

```markdown
# 第{N}集诊断报告

## 总评
- 综合评分：{分数}/100
- 结论：{通过/未通过}
- 致命问题：{数量}
- 严重问题：{数量}

## 各维度评分
| 维度 | 得分 | 权重 | 加权分 |
|------|------|------|--------|
| 情节忠实度 | {x}/100 | 35% | {y} |
| ... | | | |

## 问题清单
### 🔴 致命问题
1. [ep01_sh05] {问题描述} → 建议：{修改方案}

### 🟠 严重问题
1. [ep01_sh12] {问题描述} → 建议：{修改方案}

## 修改建议（按镜头）
- ep01_sh05：{具体到镜头级的修改指导}
- ep01_sh12：{具体到镜头级的修改指导}
```

## 原创项目诊断（简化版）
原创项目无原著对照，仅检查：
- 角色一致性（性格/行为/服装前后一致）
- 情节逻辑（因果链无断裂）
- 节奏合理性（不过快/过慢）
- 连贯性（跨集衔接）
