# 设计指南 (Design Guide)

## 角色设计

### 角色设计卡模板

```json
{
  "name": "角色名",
  "character_id": "char_xxx",
  "gender": "男/女",
  "age": 24,
  "identity": "身份定位（一句话）",
  "personality": {
    "core_traits": "核心性格特征",
    "speech_style": "说话风格",
    "motivation": "核心动机"
  },
  "appearance": {
    "hair": "发型/发色",
    "face_features": "面部特征",
    "body_type": "体型"
  },
  "variants": {
    "变体名": {
      "description": "该状态描述",
      "outfit": "上装、下装、鞋、配饰",
      "face_modifier": "该状态的面部变化",
      "prompt": "完整角色提示词"
    }
  },
  "voice_default": {
    "timbre": "声线描述",
    "speed": "语速",
    "accent": "口音"
  }
}
```

### 角色提示词公式

```
{时代}、{年龄}岁、{性别}、{发型/发色}、{上装}、{下装}、{鞋/配饰}、{面部特征}，
{风格标签}，{景别}，纯色背景，面向镜头
```

**景别：** 默认"全身"。如角色以半身出镜为主，可额外生成"半身"版本。
**纯色背景+面向镜头：** 始终包含，便于AI工具抠图和后续引用。

### 状态变体设计原则

- 每个变体的服装、面部特征、发型都可能不同
- 变体命名用中文短语，要有辨识度
- 常见变体类型：

| 变体类型 | 示例 |
|---------|------|
| 服装变化 | 日常 / 正装 / 战斗装 / 校服 |
| 状态变化 | 觉醒前 / 觉醒后 |
| 伤势变化 | 健康 / 受伤 / 康复 |
| 年龄变化 | 少年 / 成年 |
| 情境变化 | 工作中 / 休闲 / 婚礼 |

### 角色一致性要点

- 同一角色所有变体共享：年龄、性别、发色（除非剧情需要改变）
- 改变的只是：服装、面部状态、发型、配饰
- 分镜引用时用 `角色名（变体名）` 确保匹配到正确的立绘

---

## 场景设计

### 场景设计卡模板

```json
{
  "name": "场景名",
  "scene_id": "scene_xxx",
  "type": "室内/室外",
  "era": "时代",
  "description": "场景叙述描述",
  "key_elements": ["核心陈设1", "核心陈设2"],
  "variants": {
    "白天": {
      "lighting": "光影描述",
      "prompt": "完整场景提示词"
    },
    "夜晚": {
      "lighting": "光影描述",
      "prompt": "完整场景提示词"
    }
  }
}
```

### 场景提示词公式

```
{时代背景}，{风格}，{室内/室外}，{时间}，{场景详细描述（空间布局+光影+陈设道具）}
```

### 场景设计要点

- 不包含任何角色，纯环境
- 陈设道具要具体（"输液架立在病床旁"而非"医疗设备"）
- 光影要具体（"阳光透过玻璃照亮室内"而非"明亮"）
- 同一场景不同时间/氛围各生成一张变体

---

## 道具设计

### 判断规则

| 需独立生成 | 不需独立生成 |
|-----------|------------|
| 剧情关键信物 | 普通家具 |
| 角色标志物 | 环境道具 |
| 多次特写的物品 | 一次性背景物 |
| 跨场景携带物品 | 场景固有陈设 |

### 道具提示词公式

```
{时代背景}，{风格}，{道具类型}，{详细外观描述}，{材质}，{颜色}
```

---

## 风格模板

### 电影写实风格
```
角色后缀：电影写实风格，高质量，真实光影，电影级打光，8K分辨率，超高清细节
场景后缀：电影写实风格
分镜后缀：写实风格，电影级打光，8K分辨率，超细节刻画
分镜增强：高对比度光影，动态模糊感，电影级质感，8K超高清
```

### 日系动漫风格
```
角色后缀：日系动漫风格，精美二次元，细腻线条，唯美画风，高清动漫CG，柔和光影
场景后缀：动漫风格
分镜后缀：日系动漫风格，唯美画风
```

### 2.5D 风格
```
角色后缀：2.5D风格，半写实渲染，精细建模，柔和光影，高清CG
场景后缀：2.5D风格
分镜后缀：2.5D风格，精细渲染，CG质感
```

**规则：全项目所有提示词使用同一风格，不混搭。**
