# 连贯性管理指南 (Continuity Guide)

## 跨集状态追踪

每集完成后输出 `continuity/ep{N}-state.json`：

```json
{
  "episode": 3,
  "character_states": {
    "角色名": {
      "variant": "当前外观变体",
      "location": "当前位置",
      "emotion": "当前情绪",
      "injuries": "伤势状态",
      "carrying": ["随身道具"]
    }
  },
  "relationship_changes": [
    { "chars": ["A", "B"], "change": "从敌对转为暂时合作" }
  ],
  "planted_threads": [
    { "thread": "伏笔描述", "planted_at": "ep02_sh15", "expected_payoff": "ep05" }
  ],
  "resolved_threads": [
    { "thread": "已回收的伏笔", "resolved_at": "ep03_sh08" }
  ],
  "props_status": {
    "道具名": "状态描述"
  },
  "next_hook": "下集开场钩子描述"
}
```

## 续写检查清单

开始新一集前必须验证：

1. **角色服装**：与上集末尾一致（除非有换装场景）
2. **角色位置**：与上集末尾一致（除非有转场说明）
3. **角色情绪**：延续上集情绪状态
4. **钩子回应**：上集钩子在前3个镜头内有回应
5. **道具状态**：道具位置和状态延续
6. **伏笔检查**：超过5集未回收的伏笔需安排回收

## 角色变体切换规则

角色外观变体切换必须有剧情触发：

```
陈易（觉醒前）→ 陈易（觉醒后）
触发事件：被雷劈后获得超能力
切换镜头：ep02_sh12（觉醒特写镜头）
从此集开始：所有后续镜头使用"觉醒后"变体
```

切换点必须在剧本和连贯性状态中明确标记。

## 多集情绪曲线

```
集1: ████░░░░ (压抑→微光)
集2: ██████░░ (挑战→初胜)
集3: ████░░░░ (挫折→低谷)
集4: ████████ (爆发→高潮)
集5: ██████░░ (余韵→新篇)
```

全剧情绪走向应有整体弧线设计，避免每集都在最高点或最低点。
