# 组装规则详解 (Assembly Rules)

## 核心逻辑：图片 → 视频的派生关系

```
角色提示词（独立立绘）  ──┐
场景提示词（空场景图）  ──┼──→ 分镜图片提示词 ──→ 视频提示词
道具提示词（独立特写）  ──┘    （用名字引用角色）   （基于图片派生）
```

**铁律：视频提示词不能独立组装，必须从分镜图片提示词派生。**

---

## 一、角色提示词组装规则

### 公式

```
{时代}、{年龄}岁、{性别}、{发型}/{发色}、{上装}、{下装}、{鞋子}、{配饰/无}，{面部特征}，
{风格标签}，{质量标签}，全身，纯色背景，面向镜头
```

### 数据来源映射

| 提示词字段 | 数据来源 |
|-----------|---------|
| 时代 | project.era |
| 年龄、性别 | character.basic_info |
| 发型/发色 | character.appearance.hair |
| 上装/下装/鞋/配饰 | character.outfits[variant_name] |
| 面部特征 | character.appearance.face_features |
| 风格标签 | style-guide.character_suffix |
| 质量标签 | style-guide.quality_tags |

### 状态变体

同一角色多状态时，每个状态独立生成一条提示词：

```json
{
  "name": "陈易",
  "gender": "男",
  "age": 24,
  "variants": {
    "觉醒前": {
      "prompt": "现代、24岁、男、短发凌乱/黑色、蓝白条纹病号服、病号裤、无、面色苍白，电影写实风格，高质量，真实光影，电影级打光，8K分辨率，超高清细节，全身，纯色背景，面向镜头",
      "desc": "病号服，虚弱苍白"
    },
    "觉醒后": {
      "prompt": "现代、24岁、男、短发利落/黑色、灰色运动外套、深蓝色运动裤、白色运动鞋、无配饰，电影写实风格，高质量，真实光影，电影级打光，8K分辨率，超高清细节，全身，纯色背景，面向镜头",
      "desc": "运动装，精神焕发"
    }
  }
}
```

### 变体命名规范

| 变体类型 | 命名示例 |
|---------|---------|
| 服装变化 | 日常、正装、战斗装、便装 |
| 状态变化 | 觉醒前、觉醒后 |
| 伤势变化 | 健康、受伤、康复 |
| 年龄变化 | 少年、成年 |
| 情境变化 | 比赛时、私下 |

---

## 二、场景提示词组装规则

### 公式

```
{时代背景}，{风格}，{室内/室外}，{时间}，{场景详描}
```

### 变体处理

同一场景不同时间/氛围各生成一条：

```json
{
  "name": "医院普通病房",
  "variants": {
    "白天": {
      "prompt": "中国现代，电影写实风格，室内，白天，现代医院普通病房，白色墙面干净整洁，输液架立在病床旁，病床白色床单，窗户透入柔和自然光"
    },
    "深夜": {
      "prompt": "中国现代，电影写实风格，室内，深夜，现代医院普通病房，白色墙面，走廊灯光透过门缝微弱照入，输液架旁机器指示灯闪烁，氛围安静压抑"
    }
  }
}
```

---

## 三、道具提示词组装规则

### 哪些道具需要独立生成？

| ✅ 需要独立生成 | ❌ 不需要 |
|---------------|---------|
| 剧情关键信物（古籍、护身符） | 普通家具（桌椅、柜子） |
| 角色标志物（武器、特殊配饰） | 环境陈设（路灯、垃圾桶） |
| 多次特写的物品 | 一次性背景物品 |
| 跨场景携带的物品 | 场景固有道具 |

### 公式

```
{时代背景}，{风格}，{道具类型}，{外观详描}，{故事意义}，{材质}，{颜色}
```

---

## 四、分镜图片提示词组装规则（核心）

### 逐步组装过程

**Step 1 — 场景层**

从场景库中取出当前场景的提示词，提取与本镜头相关的核心视觉元素：

```
场景库原文：中国现代，电影写实风格，室内，白天，现代医院普通病房，白色墙面干净整洁，输液架立在病床旁，病床白色床单，窗户透入柔和自然光
    ↓ 提取关键元素
分镜场景层：中国现代，医院普通病房，白色墙面，输液架，病床，柔和冷光
```

不需要全部复制。只取本镜头画面中可见的元素。

**Step 2 — 镜头层**

确定景别，用中文自然语言：

| 景别 | 提示词写法 |
|------|-----------|
| 特写 | `特写镜头（面部）` / `特写镜头（手部）` |
| 近景 | `近景镜头（胸部以上）` |
| 中景 | `中景镜头` |
| 全景 | `全景镜头` |
| 远景 | `远景镜头` |

**Step 3 — 角色层（关键！）**

**必须用角色名字**，不用外貌描述替代。

```
✅ 画面右侧陈勇背影离去，张慧芬转身替病床上的陈易（觉醒前）整理输液管，轻叹气，眼神略带无奈
❌ 画面右侧中年男性背影离去，护士女性转身替病床上的苍白青年整理输液管
```

多角色时描述每个角色的位置和动作：

```
画面右侧 + 陈勇 + 背影离去
            张慧芬 + 转身替...整理输液管 + 轻叹气 + 眼神略带无奈
病床上 + 陈易（觉醒前）
```

有状态变体的角色必须标注当前状态：`陈易（觉醒前）`、`林峰（觉醒后）`

**Step 4 — 道具层**

关键道具用名字融入描述：
```
陈易双手颤抖翻开天机古卷  ← 关键道具用名字
输液架立在病床旁          ← 普通道具融入场景描述
```

**Step 5 — 风格层**

追加全局风格和质量标签：

```
写实风格，电影级打光，8K分辨率，超细节刻画
日系动漫风格，唯美画风
```

**可选增强词（按镜头需要添加）：**
```
动态模糊感、高对比度光影、电影级质感、汗水飞溅
```

### 完整组装示例

```
[场景层]  中国现代，医院普通病房，白色墙面，输液架，病床，柔和冷光，
[镜头层]  近景镜头（胸部以上），
[角色层]  画面右侧陈勇背影离去，张慧芬转身替病床上的陈易（觉醒前）整理输液管，轻叹气，眼神略带无奈，
[风格层]  写实风格，电影级打光，8K分辨率，超细节刻画
```

最终输出为一个连续字符串（中间用逗号和空格分隔）。

---

## 五、视频提示词派生规则（核心）

### 派生步骤

**Step 1 — 场景扩写**

将分镜中的场景关键词**扩写为完整叙述句**：

```
分镜: 医院普通病房，白色墙面，输液架，病床，柔和冷光
  ↓
视频: 场景为中国现代医院普通病房，白色墙面干净整洁，输液架立在病床旁，柔和冷光洒满房间。
```

**Step 2 — 起始镜头**

选择一个角色或画面作为起始镜头，转为动态描述，标注性别：

```
分镜: 画面右侧陈勇背影离去，张慧芬转身
  ↓
视频: 镜头从张慧芬(女)的近景开始，她站在病床边，目光望向画面右侧，陈勇(男)的背影正缓缓走出病房门口，写实风格，电影级打光。
```

**Step 3 — 切镜 + 对白嵌入**

用"切镜到"衔接下一个镜头，嵌入对白（带动作描写）：

```
切镜到张慧芬(女)的近景（胸部以上），她收回目光转身面向病床上的陈易，双手轻柔整理输液管，轻叹气，嘴唇微动说着："唉，陈易，你的医药费已经拖欠三天了..."，眼神略带无奈，超细节刻画手部动作，8K分辨率。
```

**Step 4 — 氛围收束**

用"最后切镜到"收束画面：

```
最后切镜到两人同框的中景，张慧芬(女)整理好输液管后低头看着陈易，病房里安静无声，氛围忧虑而沉重，无背景音乐。
```

**Step 5 — 性别声明**

末尾追加所有出场角色的性别：

```
陈勇是男性，张慧芬是女性
```

### 对白嵌入格式

| 情绪 | 动作描写+对白格式 |
|------|-----------------|
| 叹息/无奈 | `轻叹气，嘴唇微动说着："..."` |
| 愤怒/狂吼 | `张嘴向场内大吼："..."` |
| 悲伤/低语 | `低声说道："..."` |
| 冷酷/威胁 | `冷冷开口道："..."` |
| 惊讶/震惊 | `瞪大眼睛脱口而出："..."` |
| 温柔/安慰 | `轻声安慰道："..."` |

### 运动描述词汇

| 动作强度 | 描述词示例 |
|---------|-----------|
| 微动 | 缓缓、轻轻、微微、慢慢 |
| 正常 | 转身、走向、伸手、拿起 |
| 强烈 | 猛地、冲到、一把抓住、用力 |
| 爆发 | 暴起、飞身、疾冲、猛然 |

---

## 六、音频描述组装

### 对白音频

```json
{
  "text": "唉，陈易，你的医药费已经拖欠三天了...",
  "speaker": "张慧芬",
  "speaker_gender": "female",
  "emotion": "无奈叹息",
  "voice_desc": "中年女性，声音疲惫温和，带叹息感，语速缓慢"
}
```

### 情绪→语音映射

| 情绪 | 语速 | 语调 | 附加特征 |
|------|------|------|---------|
| 冷酷/威胁 | 慢 | 低沉 | 压迫感 |
| 愤怒/狂吼 | 快 | 高亢 | 爆发力，可带破音 |
| 悲伤/无奈 | 慢 | 低 | 叹息感，气声 |
| 嘲讽 | 中 | 中高 | 拖音，上扬 |
| 激动/狂热 | 快 | 高 | 嘶吼，爆发力极强 |

### 音效

```json
{
  "sfx": [
    { "type": "脚步声远去", "timing": "陈勇离开时", "volume": "低" },
    { "type": "输液管碰撞", "timing": "张慧芬整理时", "volume": "轻微" },
    { "type": "观众欢呼沸腾", "timing": "全程背景", "volume": "中" }
  ]
}
```

### BGM

```json
{
  "bgm": {
    "mood": "无",
    "note": "无背景音乐，保持安静压抑氛围"
  }
}
```

或：

```json
{
  "bgm": {
    "mood": "紧张激烈",
    "note": "快节奏电子/鼓点，渐强到高潮"
  }
}
```

---

## 七、风格标签库

### 写实风格
```
角色后缀：电影写实风格，高质量，真实光影，电影级打光，8K分辨率，超高清细节
分镜后缀：写实风格，电影级打光，8K分辨率，超细节刻画
增强词（按需）：动态模糊感，高对比度光影，电影级质感
```

### 日系动漫
```
角色后缀：日系动漫风格，精美二次元，细腻线条，唯美画风，高清动漫CG，柔和光影
分镜后缀：日系动漫风格，唯美画风
增强词（按需）：动态线条，色彩鲜艳，光影柔和
```

### 古风写实
```
角色后缀：中国古风，电影写实风格，古装质感，自然光影，水墨意境，8K分辨率
分镜后缀：古风写实，水墨意境，自然光影
增强词（按需）：烟雾缭绕，丁达尔光效，朦胧美感
```
