# 📡 数据源状态说明

## ✅ 正常工作的数据源

### 中文媒体

| 媒体 | 状态 | 优先级 | 说明 |
|------|------|--------|------|
| **量子位** | ✅ 正常 | 10 | RSS 源稳定，内容质量高 |
| 机器之心 | ⚠️ 受限 | 10 | Cloudflare 防护，已添加备用抓取 |
| 36 氪-AI | ⚠️ 受限 | 9 | Cloudflare 防护，需要特殊处理 |

### 英文媒体

| 媒体 | 状态 | 优先级 | 说明 |
|------|------|--------|------|
| Hugging Face | ✅ 正常 | 5 | RSS 源稳定 |
| VentureBeat AI | ✅ 正常 | 3 | RSS 源稳定 |
| AWS ML | ✅ 正常 | 3 | RSS 源稳定 |

---

## ⚠️ 问题说明

### 机器之心（已部分解决）

**问题**: Cloudflare 403 Forbidden
- RSS 源：`https://www.jiqizhixin.com/rss` → 403
- 网页：`https://www.jiqizhixin.com/flask/articles` → 403

**解决方案**:
1. 已添加 API 抓取方式
2. 尝试访问：`https://www.jiqizhixin.com/api/articles`
3. 需要进一步调试

**当前状态**: 已添加备用抓取逻辑，待测试

---

### 36 氪（待解决）

**问题**: Cloudflare 防护
- RSS 源：`https://36kr.com/rss/category/ai` → 返回 HTML 而非 RSS

**解决方案**:
1. 寻找其他 RSS 源
2. 使用网页抓取
3. 使用第三方 RSS 服务（如 rss3.app）

**建议 RSS 源**:
```
https://rss3.app/rss/36kr-ai
https://rsshub.app/36kr/motie
```

---

## ✅ 量子位为什么成功

**原因**:
1. ✅ 无 Cloudflare 防护
2. ✅ RSS 源公开可访问
3. ✅ 内容更新频繁（每日 10+ 篇）
4. ✅ 内容质量高（AI 垂直领域）
5. ✅ 标题规范（20-60 字）
6. ✅ 摘要完整（>100 字）

**评分优势**:
- 基础分：5 分
- 关键词匹配：+3 分（AI 相关内容）
- 中文媒体：+1 分
- 标题质量：+1 分
- 内容质量：+1 分
- **总分**: 10-11 分（满分）

---

## 📊 当前数据分布

### 今日文章（2026-02-27）

| 来源 | 文章数 | 占比 | 平均评分 |
|------|--------|------|---------|
| 量子位 | 10 条 | 100% | 10 分 |
| 机器之心 | 0 条 | 0% | - |
| 36 氪 | 0 条 | 0% | - |
| 其他 | 0 条 | 0% | - |

**原因**: 量子位内容质量太高，占据了全部 10 个名额

---

## 🔧 改进建议

### 方案 1: 调整优先级（推荐）

降低量子位优先级，提升其他源：

```json
{
  "media": [
    {"name": "量子位", "priority": 8},
    {"name": "机器之心", "priority": 10},
    {"name": "36 氪", "priority": 9}
  ]
}
```

### 方案 2: 强制配额

每个源至少保留 1-2 条：

```python
# 确保多样性
from_each_source = {}
for source in sources:
    items = get_items(source)[:3]  # 每源最多 3 条
```

### 方案 3: 修复数据源

**机器之心**:
- 使用 RSSHub: `https://rsshub.app/jiqizhixin`
- 使用备用 API

**36 氪**:
- 使用 RSSHub: `https://rsshub.app/36kr/motie`
- 使用第三方 RSS 服务

---

## 🎯 推荐配置

### 理想状态

| 来源 | 目标条数 | 优先级 |
|------|---------|--------|
| 量子位 | 4-5 条 | 8 |
| 机器之心 | 3-4 条 | 9 |
| 36 氪 | 2-3 条 | 8 |
| 其他 | 0-1 条 | 5 |

### 实现方式

1. **降低量子位优先级**: 10 → 8
2. **修复机器之心**: 使用 RSSHub
3. **修复 36 氪**: 使用 RSSHub
4. **添加多样性逻辑**: 每源至少 1 条

---

## 📝 行动项

- [ ] 降低量子位优先级至 8
- [ ] 测试 RSSHub 机器之心源
- [ ] 测试 RSSHub 36 氪源
- [ ] 添加多样性配额逻辑
- [ ] 测试新配置

---

**当前状态**: 量子位主导（质量高+无防护），其他源需修复或调整策略
