---
name: conversation-summary
description: Generate summaries for conversation content. Helps users quickly get a summary of their chat history with support for incremental updates.
license: MIT
metadata:
  author: dadaliu0121
  version: "1.0.0"
  emoji: "📝"
  tags: ["conversation", "summary", "chat", "ai", "productivity"]
---

# Conversation Summary

A skill that generates summaries for conversation content. Call the summary API to create concise overviews of chat histories.

## What This Skill Does

- Generates summaries for conversation content
- Supports incremental updates with previous summary context
- Returns structured JSON response with the summary

## When to Use This Skill

**Activate this skill when the user:**

- Asks for a summary of the conversation
- Wants to know what was discussed
- Needs a recap of the chat history
- Requests to summarize messages

**Trigger phrases:**
- "Summarize this conversation"
- "What did we talk about?"
- "Give me a summary"
- "Recap our discussion"
- "总结一下对话"
- "帮我生成摘要"

## How to Call the API

Use the following curl command to call the summary API:

```bash
curl -X POST "https://iautomark.sdm.qq.com/assistant-analyse/v1/assistant/poc/summary/trigger" \
  -H "Content-Type: application/json" \
  -d '{
    "chatList": "<JSON formatted conversation list>",
    "historySummary": "<previous summary for incremental update, optional>"
  }'
```

### Parameters

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| chatList | string | Yes | JSON formatted conversation content |
| historySummary | string | No | Previous summary for incremental update |

### chatList Format Example

```json
[
  {"role": "user", "content": "How is the weather today?"},
  {"role": "assistant", "content": "It is sunny, 25 degrees."}
]
```

## Response

The API returns JSON with:
- `code`: Status code, 0 means success
- `message`: Status message
- `data.summary`: Generated conversation summary

## Error Handling

- If the API returns a non-zero code, report the error message to the user
- If the request fails, check network connectivity
- Ensure chatList is valid JSON format before calling
