---
name: ai-customer-service
description: 智能客服系统，支持FAQ自动回复、意图识别、多轮对话
command-dispatch: tool
command-tool: ai_customer_service
command-arg-mode: raw
metadata: {"openclaw": {"emoji": "💬", "requires": {"bins": ["python3"]}}}
---

# 💬 AI Smart Customer Service 智能客服

基于LLM的智能客服系统，支持FAQ匹配、意图识别、多轮对话。

## 🎯 功能列表

### 核心功能
- ✅ **FAQ自动回复**：预设知识库+智能匹配
- ✅ **意图识别**：自动判断用户意图（咨询/投诉/建议/转人工）
- ✅ **多轮对话**：支持上下文的多轮对话
- ✅ **情绪检测**：识别用户情绪（正面/中性/负面）
- ✅ **知识库管理**：支持添加/查询FAQ
- ✅ **转人工**：高优先级自动转人工提醒

### 支持的场景
- 🛍️ 电商咨询（退货、快递、支付）
- 💼 企业内部FAQ
- 📞 技术支持
- 🏥 基础咨询

## 📖 使用方法

### 基本语法
```
/ai-customer-service <操作> [参数]
```

### 示例

**1. 开始对话**
```
/ai-customer-service chat 你好
```

**2. 咨询问题**
```
/ai-customer-service chat 如何退货？
```

**3. 添加FAQ**
```
/ai-customer-service add 你们支持7天无理由退货吗？ 支持的，请在收到商品7天内申请退款。
```

**4. 查看知识库**
```
/ai-customer-service list
```

**5. 查看统计**
```
/ai-customer-service stats
```

**6. 清空对话历史**
```
/ai-customer-service clear
```

## 💬 对话示例

**用户**: 我想退货
**AI**: 您好！关于退货，请注意以下信息：

📦 退货政策：
- 7天内无理由退货（商品未拆封）
- 质量问题30天内可退换
- 退货需保持原包装和配件完整

请问您是因为什么原因要退货呢？
1. 商品质量问题
2. 不喜欢/不想要了
3. 尺寸/规格不合适
4. 其他原因

**用户**: 质量问题
**AI**: 非常抱歉给您带来不便！质量管理保退换：

✅ 质量问题处理流程：
1. 拍摄商品瑕疵照片
2. 联系客服说明情况
3. 我们会安排快递上门取件
4. 收到商品后3天内退款

请问需要我帮您申请退货吗？

## 📚 内置知识库

| 问题 | 答案 |
|------|------|
| 你们支持7天无理由退货吗？ | 支持的，请在收到商品7天内申请退款。 |
| 运费由谁承担？ | 非人为损坏由商家承担，人为损坏需买家承担。 |
| 发货需要多长时间？ | 正常情况下24小时内发货，48小时内物流更新。 |
| 支持哪些支付方式？ | 支持微信、支付宝、银行卡、货到付款。 |
| 如何查询物流？ | 可以在"我的订单"中查看物流信息。 |
| 你们有实体店吗？ | 目前只支持线上购买，全国可配送。 |
| 可以修改订单地址吗？ | 未发货前可以修改，请联系客服处理。 |
| 退货地址在哪里？ | 退货地址：广东省深圳市宝安区xxx，联系电话：400-xxx-xxxx |

## 🎯 意图识别

系统会自动识别以下意图：

| 意图 | 关键词 | 处理方式 |
|------|--------|----------|
| 退货 refund | 退货、退款、不想要了 | 引导退货流程 |
| 物流 logistics | 物流、快递、到哪里了 | 查询物流 |
| 支付 payment | 支付、付款、怎么付 | 支付指引 |
| 投诉 complaint | 投诉、差评、失望 | 转人工处理 |
| 建议 suggestion | 建议、希望、能够 | 记录并反馈 |
| 问候 greeting | 你好、hi、hello | 友好回应 |

## 🎭 情绪分析

| 情绪 | 关键词 | 响应策略 |
|------|--------|----------|
| 😄 正面 | 谢谢、满意、太好了 | 感谢并积极回应 |
| 😐 中性 | 请问、我想知道 | 正常解答 |
| 😔 负面 | 生气、失望、太差了 | 道歉并转人工 |

## ⚙️ 配置选项

```json
{
  "skills": {
    "entries": {
      "ai-customer-service": {
        "enabled": true,
        "config": {
          "autoReply": true,
          "transferThreshold": 3,
          "sentimentThreshold": -0.5
        }
      }
    }
  }
}
```

## 🚀 快速使用

直接告诉我：
- "我想退货"
- "物流到哪了"
- "你们支持分期吗"
- "我要投诉"