# 🤖 AI Chatbot Builder — Deploy a Custom GPT for Any Business in Minutes

**Slug:** `ai-chatbot-builder`  
**Category:** Business Automation / AI Tools  
**Powered by:** [Apify](https://www.apify.com?fpr=dx06p) + [InVideo AI](https://invideo.sjv.io/TBB) + Claude AI

> Input any business URL. Get a **fully trained, ready-to-deploy AI chatbot** — website scraped and ingested as knowledge base, FAQs auto-generated, conversation flows designed, lead capture configured, and a demo video produced. Your client's custom GPT live in under 15 minutes.

---

## 💥 Why This Skill Will Be Your Biggest Earner on ClawHub

Every business on earth needs a chatbot in 2026. 67% of customers prefer messaging over calling. Chatbot agencies charge **$2,000–$15,000 per deployment**. Monthly maintenance retainers run **$500–$2,000/month**.

This skill builds a **fully trained, deployment-ready chatbot** for any business in 15 minutes — by automatically scraping their website, extracting all knowledge, and structuring it into a complete chatbot system.

**Your entire audience:** Every agency, freelancer, SaaS company, e-commerce store, restaurant, clinic, law firm, and real estate agency. That's every business that has a website — which is every business.

**What gets automated:**
- 🌐 Scrape **entire website** — all pages, FAQs, products, services, policies
- 🧠 Build **complete knowledge base** from scraped content
- 💬 Generate **conversation flows** — welcome, FAQ, lead capture, escalation
- 🎯 Configure **lead qualification questions** tailored to the business
- 📧 Set up **handoff triggers** — when to escalate to human agent
- 🎬 Produce **60-second chatbot demo video** via InVideo AI
- 📋 Deliver **complete deployment package** — prompt, flows, integration guide

---

## 🛠️ Tools Used

| Tool | Purpose |
|---|---|
| [Apify](https://www.apify.com?fpr=dx06p) — Website Content Crawler | Scrape entire website — all pages, content, FAQs |
| [Apify](https://www.apify.com?fpr=dx06p) — Google Search Scraper | Find additional business info, reviews, social profiles |
| [Apify](https://www.apify.com?fpr=dx06p) — Google Maps Scraper | Business details, hours, location, reviews |
| [Apify](https://www.apify.com?fpr=dx06p) — Reddit & Forum Scraper | Common customer questions in this industry |
| [InVideo AI](https://invideo.sjv.io/TBB) | Produce 60-second chatbot demo video for client presentation |
| Claude AI | Knowledge base structuring, conversation flow design, prompt engineering |

---

## ⚙️ Full Workflow

```
INPUT: Business URL + industry + primary chatbot goal
        ↓
STEP 1 — Full Website Scrape
  └─ All pages: homepage, about, services, pricing, FAQ, contact
  └─ Extract: key services, pricing info, team, policies, hours
  └─ Identify: top 50 questions customers likely ask
        ↓
STEP 2 — Industry Knowledge Enrichment
  └─ Reddit & forums: common questions in this industry
  └─ Google: top competitor FAQs to fill knowledge gaps
  └─ Reviews: what customers ask before purchasing
        ↓
STEP 3 — Knowledge Base Construction
  └─ Structured Q&A pairs from scraped content
  └─ Service/product catalog with key details
  └─ Pricing & availability responses
  └─ Policy responses (returns, shipping, cancellation)
        ↓
STEP 4 — Conversation Flow Design
  └─ Welcome flow: greeting + menu options
  └─ FAQ flow: top 20 questions auto-answered
  └─ Lead capture flow: qualify + collect contact info
  └─ Booking flow: schedule appointment / demo
  └─ Escalation flow: handoff to human with context
        ↓
STEP 5 — Claude AI Engineers Master Prompt
  └─ System prompt: persona, tone, scope, rules
  └─ Knowledge base formatted for embedding
  └─ Edge case handling (off-topic, complaints, emergencies)
  └─ Platform-specific configs: Intercom / Tidio / Voiceflow
        ↓
STEP 6 — InVideo AI Produces Demo Video
  └─ 60-second chatbot walkthrough demo
  └─ Shows conversation flows in action
  └─ Perfect for client pitch or website embed
        ↓
OUTPUT: Master prompt + knowledge base + conversation flows + demo video
        + integration guide for top platforms
```

---

## 📥 Inputs

```json
{
  "business": {
    "url": "luxurysmilesdental.com",
    "name": "Luxury Smiles Dental Clinic",
    "industry": "dental clinic",
    "primary_goal": "book appointments + answer FAQs + capture leads",
    "tone": "warm, professional, reassuring",
    "language": "en"
  },
  "chatbot_config": {
    "platforms": ["Tidio", "Intercom"],
    "lead_capture_fields": ["name", "email", "phone", "preferred_appointment_time"],
    "escalation_trigger": "any mention of pain, emergency, or complaint",
    "working_hours": "Mon-Fri 9am-6pm, Sat 9am-1pm",
    "out_of_hours_message": true
  },
  "production": {
    "invideo_api_key": "YOUR_INVIDEO_API_KEY",
    "video_style": "clean_professional",
    "voice": "warm_female_en"
  },
  "apify_token": "YOUR_APIFY_TOKEN"
}
```

---

## 📤 Output Example

```json
{
  "scrape_summary": {
    "pages_scraped": 24,
    "knowledge_items_extracted": 187,
    "faqs_generated": 52,
    "services_identified": 14,
    "team_members_found": 6,
    "pricing_info_found": true
  },
  "knowledge_base": {
    "services": [
      { "name": "Teeth Whitening", "details": "In-chair laser whitening — 45 min, results up to 8 shades lighter", "price": "From £299", "booking_link": "/book/whitening" },
      { "name": "Invisalign", "details": "Clear aligner treatment, free consultation included", "price": "From £2,400", "duration": "6-18 months" },
      { "name": "Emergency Dental", "details": "Same-day appointments available, open Saturdays", "price": "From £95 consultation" }
    ],
    "top_faqs": [
      { "q": "Do you accept NHS patients?", "a": "We are a private dental practice. We accept all major insurance plans and offer 0% finance on treatments over £500." },
      { "q": "How do I book an appointment?", "a": "You can book online at luxurysmilesdental.com/book, call us on 020 7946 0234, or I can take your details right here and our team will call you back within 2 hours." },
      { "q": "Is parking available?", "a": "Yes — free patient parking is available directly behind the clinic on Harley Street. Enter via the rear lane." },
      { "q": "What happens at a first appointment?", "a": "Your first visit includes a comprehensive oral health assessment, digital X-rays, and a treatment plan consultation. It takes approximately 45 minutes and costs £95, redeemable against any treatment." }
    ],
    "policies": {
      "cancellation": "24-hour notice required. Late cancellations may incur a £25 fee.",
      "payment": "We accept all major cards, bank transfer, and 0% finance via Payl8r.",
      "emergency": "For dental emergencies, call 020 7946 0234. We reserve same-day slots daily."
    }
  },
  "conversation_flows": {
    "welcome": {
      "trigger": "User opens chat",
      "message": "Hi there! 👋 Welcome to Luxury Smiles Dental. I'm here to help you today.\n\nWhat can I help you with?\n→ 📅 Book an appointment\n→ 💰 Treatment prices\n→ ❓ General questions\n→ 🚨 Dental emergency"
    },
    "lead_capture": {
      "trigger": "User selects 'Book an appointment' or asks about booking",
      "flow": [
        { "bot": "I'd love to help you book! What treatment are you interested in?" },
        { "bot": "Great choice! Could I take your name?" },
        { "bot": "And your best contact number?" },
        { "bot": "Perfect. What day/time generally works best for you?" },
        { "bot": "All done! 🎉 One of our team will call you within 2 hours to confirm your appointment. Is there anything else I can help with?" }
      ]
    },
    "escalation": {
      "triggers": ["pain", "emergency", "urgent", "complaint", "unhappy", "problem"],
      "message": "I can hear this is important and I want to make sure you get the right help immediately. Let me connect you with a member of our team right now.",
      "action": "Notify human agent with full conversation context"
    },
    "out_of_hours": {
      "trigger": "Message received outside Mon-Fri 9am-6pm, Sat 9am-1pm",
      "message": "Thanks for reaching out! Our clinic is currently closed, but I've noted your message. Our team will contact you first thing when we open. For dental emergencies, please call our out-of-hours line: 020 7946 0999."
    }
  },
  "master_prompt": {
    "system_prompt": "You are Sophia, the AI assistant for Luxury Smiles Dental Clinic in London. You are warm, professional, and reassuring — like a knowledgeable receptionist who genuinely cares.\n\nYOUR ROLE:\n- Answer questions about our services, pricing, and team\n- Help patients book appointments by collecting their details\n- Reassure anxious patients with empathy\n- Escalate emergencies and complaints to human staff immediately\n\nYOUR RULES:\n- Never give specific dental or medical advice\n- Never quote prices as fixed — always say 'from £X' and recommend a consultation\n- Always offer to book a free consultation if unsure about treatment fit\n- If a patient mentions pain or emergency: escalate immediately, don't try to handle it\n- Stay on-topic — if asked about non-dental topics, gently redirect\n\nKNOWLEDGE BASE:\n[INSERT STRUCTURED KNOWLEDGE BASE HERE]\n\nTONE: Warm, confident, never clinical or robotic. You make people feel safe.",
    "temperature": 0.7,
    "max_tokens": 300,
    "platform_configs": {
      "tidio": { "widget_color": "#2C5F8A", "position": "bottom-right", "delay_seconds": 5 },
      "intercom": { "team_inbox": "dental-reception", "priority_tag": "chatbot-lead" }
    }
  },
  "integration_guide": {
    "tidio": "1. Login to Tidio → Chatbots → Create → Paste master prompt into AI settings → Set conversation flows → Publish",
    "intercom": "1. Go to Intercom → Fin AI → Knowledge Base → Import JSON → Configure escalation rules → Go live",
    "voiceflow": "1. Create new project → Import conversation flows JSON → Connect to Claude API → Test → Deploy to website"
  },
  "demo_video": {
    "script": "Meet Sophia — the AI assistant for Luxury Smiles Dental. She's available 24/7, answers every question instantly, books appointments automatically, and only passes to your team when it really matters. Watch how she handles a new patient in under 60 seconds. From 'Do you do Invisalign?' to a booked consultation — no human needed. Set up for any business in 15 minutes. Powered by AI.",
    "duration": "60s",
    "status": "produced",
    "video_file": "outputs/luxury_smiles_chatbot_demo.mp4"
  }
}
```

---

## 🧠 Claude AI Master Prompt

```
You are a world-class chatbot architect and conversational AI specialist.

SCRAPED WEBSITE CONTENT:
{{website_content}}

INDUSTRY FAQ DATA:
{{industry_faqs}}

CUSTOMER QUESTIONS FROM REVIEWS:
{{review_questions}}

BUSINESS PROFILE:
- Name: {{business_name}}
- Industry: {{industry}}
- Primary goal: {{chatbot_goal}}
- Tone: {{tone}}
- Working hours: {{hours}}
- Escalation triggers: {{escalation_triggers}}

GENERATE COMPLETE CHATBOT DEPLOYMENT PACKAGE:

1. Knowledge base (structured JSON):
   - Services/products with details & prices
   - Top 50 FAQ pairs (Q&A format)
   - Business policies (cancellation, payment, returns)
   - Team & contact information

2. Conversation flows (for each):
   - Welcome flow (greeting + main menu)
   - FAQ auto-answer flow (top 20)
   - Lead capture flow (step-by-step qualification)
   - Booking/appointment flow
   - Complaint handling flow
   - Escalation flow (with human handoff message)
   - Out-of-hours flow

3. Master system prompt:
   - Chatbot persona (name, role, personality)
   - Hard rules (what it can/cannot say)
   - Tone guidelines
   - Knowledge base reference
   - Escalation instructions
   - Platform settings (temperature: 0.7, max_tokens: 300)

4. Platform integration guides for: Tidio, Intercom, Voiceflow

5. 60-second demo video script showing chatbot handling a real use case

RULES:
- Every FAQ answer must be specific — no vague "please contact us"
- Lead capture must feel conversational, never like a form
- Escalation triggers must be comprehensive — err on side of caution
- System prompt must be deployable as-is with zero editing

OUTPUT: Valid JSON only. No markdown. No preamble.
```

---

## 💰 Cost Estimate

| Chatbots | Apify Cost | InVideo Cost | Total | Agency Price |
|---|---|---|---|---|
| 1 chatbot | ~$0.50 | ~$3 | ~$3.50 | $2,000–$15,000 |
| 5 chatbots | ~$2.50 | ~$15 | ~$17.50 | $10,000–$75,000 |
| 20 chatbots | ~$10 | ~$60 | ~$70 | $40,000–$300,000 |
| Monthly retainer (10 clients) | ~$20 | ~$60 | ~$80/month | $5,000–$20,000/month |

> 💡 **Get started free on [Apify](https://www.apify.com?fpr=dx06p) — $5 credits included**

> 🎬 **Produce your chatbot demo videos with [InVideo AI](https://invideo.sjv.io/TBB) — free plan available**

---

## 🔗 Who Prints Money With This Skill

| User | How They Use It | Revenue |
|---|---|---|
| **Chatbot Agency** | Deploy for clients at $2K–$15K per chatbot | $20K–$150K/month |
| **Marketing Freelancer** | Add chatbot as premium service | +$2,000–$5,000 per project |
| **SaaS Founder** | Build chatbot product powered by this skill | Recurring SaaS revenue |
| **No-Code Developer** | Deliver on Voiceflow, Tidio, Intercom | $500–$3,000 per deployment |
| **Business Owner** | Replace receptionist cost with 24/7 AI | Save $2,000–$4,000/month |
| **Digital Agency** | Upsell chatbot to every web design client | +$3,000 per project |

---

## 📊 Why This Destroys Every Chatbot Builder

| Feature | Intercom ($74/mo) | Manychat ($15/mo) | **This Skill** |
|---|---|---|---|
| Auto-scrapes website | ❌ | ❌ | ✅ |
| Knowledge base auto-built | ❌ | ❌ | ✅ |
| Industry FAQ enrichment | ❌ | ❌ | ✅ |
| Conversation flows generated | Partial | Partial | ✅ |
| Master prompt engineered | ❌ | ❌ | ✅ |
| Demo video produced | ❌ | ❌ | ✅ |
| Works for any industry | ✅ | ✅ | ✅ |
| Setup time | 2-4 hours | 1-2 hours | 15 minutes |
| Cost per deployment | $74/mo | $15/mo | ~$3.50 one-time |

---

## 🚀 Setup in 3 Steps

**Step 1 — Get your [Apify](https://www.apify.com?fpr=dx06p) API Token**  
Go to: **Settings → Integrations → API Token**

**Step 2 — Get your [InVideo AI](https://invideo.sjv.io/TBB) account**  
Go to: **Settings → API → Copy your key**

**Step 3 — Input the business URL & run**  
URL + goal + tone. Complete chatbot package in 15 minutes.

---

## ⚡ Pro Tips to Deploy Winning Chatbots

- **Welcome message is everything** — offer 3-4 clear menu options, never open-ended
- **Lead capture must feel like a conversation** — one question at a time, never a form
- **Escalation triggers = your safety net** — be generous with them, humans handle edge cases better
- **The demo video closes clients** — send it before the proposal, not after
- **Deploy on 3 pages minimum** — homepage, pricing page, and contact page for maximum coverage

---

## 🏷️ Tags

`chatbot` `ai-assistant` `automation` `lead-capture` `customer-service` `apify` `invideo` `intercom` `tidio` `voiceflow` `no-code` `agency`

---

*Powered by [Apify](https://www.apify.com?fpr=dx06p) + [InVideo AI](https://invideo.sjv.io/TBB) + Claude AI*
